package com.valor.vod.common.web.model;

import com.valor.vod.api.model.common.AbstractPrintable;
import com.valor.vod.common.web.constant.RequestDataNotNull;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 公共请求体
 *
 * @author Bruce Wu
 * @since 2023-03-03
 */
@Getter
@Setter
@Accessors(chain = true)
public class BaseRequest<T> extends AbstractPrintable implements Serializable {

    /**
     * 用户ID
     *
     * @mock 1421341
     */
    private Long uid;

    /** 请求数据 */
    @Valid
    @NotNull(message = "requestData is null", groups = RequestDataNotNull.class)
    private T requestData;
}
