package com.valor.vod.common.web.model;

import com.valor.vod.api.model.common.AbstractPrintable;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.tools.ErrorManager;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 公共响应体
 *
 * @author Bruce Wu
 * @since 2023-03-03
 */
@Setter
@Getter
@Accessors(chain = true)
public class BaseResponse<T> extends AbstractPrintable implements Serializable {
    /**
     * 错误码
     *
     * @mock 00000
     */
    private String code = ErrorManager.getRespCode(SystemErrorCodes.OK);
    /**
     * 错误信息
     *
     * @mock ok
     */
    private String msg = "ok";

    /**
     * 链路ID
     *
     * @mock 1111111111
     */
    private String traceId;

    /** 响应数据 */
    private T data;

    public static <T> BaseResponse<T> ok() {
        return new BaseResponse<>();
    }

    public static <T> BaseResponse<T> ok(T data) {
        BaseResponse<T> response = new BaseResponse<>();
        response.setData(data);
        return response;
    }
}
