package com.valor.vod.common.web.model;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 分页参数
 *
 * @author Bruce Wu
 * @since 2023-03-05
 */
@Setter
@Getter
@Accessors(chain = true)
public class Page implements Serializable {

    /**
     * 分页ID
     *
     * @mock 1
     */
    protected int pageId = 1;
    /**
     * 分页大小
     *
     * @mock 10
     */
    protected int pageSize = 10;
    /**
     * 总数量大小
     *
     * @mock 980
     */
    protected long count;
    /**
     * 页数
     *
     * @mock 5
     */
    protected int pages;

    /**
     * 是否有下一页
     *
     * @mock true
     */
    protected boolean hasNext;

    public Page() {}

    public Page(int pageId, int pageSize) {
        this.pageId = pageId;
        this.pageSize = pageSize;
    }

    public Page(int pageId, int pageSize, long count) {
        this.pageId = pageId;
        this.pageSize = pageSize;
        setCount(count);
    }

    public void setCount(long count) {
        this.count = count;
        this.pages = (int) (count / pageSize + (count % pageSize == 0 ? 0 : 1));
        this.hasNext = this.pageId < this.pages;
    }

    /**
     * 获取起始页Index
     *
     * @return
     */
    public int getPageStart() {
        return (pageId - 1) * pageSize;
    }

    /**
     * 根据请求page和总count计算返回Page
     *
     * @param from 请求Page
     * @param count 总数
     * @return
     */
    public static Page from(Page from, long count) {
        Page page = new Page();
        page.setPageId(from.getPageId());
        page.setPageSize(from.getPageSize());
        page.setCount(count);
        return page;
    }
}
