package com.valor.vod.common.web.model;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公共响应体(带分页)
 *
 * @author Bruce Wu
 * @since 2023-03-05
 */
@Setter
@Getter
@Accessors(chain = true)
public class PageResponse<T> extends BaseResponse<List<T>> {

    /** 分页参数 */
    private Page page;

    public static <T> PageResponse<T> ok(List<T> data, Page page) {
        PageResponse<T> resp = new PageResponse<>();
        resp.setPage(page).setData(data);
        return resp;
    }
}
