package com.valor.vod.common.web.tools;

import com.valor.vod.common.web.constant.ErrorCode;

/**
 * 业务异常
 *
 * @author Bruce Wu
 * @since 2023-03-03
 */
public class BizResponseException extends RuntimeException {
    /** 错误码 */
    private final ErrorCode errorCode;
    /** 是否打印日志，默认为true */
    private final boolean log;

    public BizResponseException(ErrorCode errorCode) {
        this(errorCode, errorCode.getDesc(), true);
    }

    public BizResponseException(ErrorCode errorCode, boolean log) {
        this(errorCode, errorCode.getDesc(), log);
    }

    public BizResponseException(ErrorCode errorCode, String message) {
        this(errorCode, message, true);
    }

    public BizResponseException(ErrorCode errorCode, String message, boolean log) {
        super(message);
        this.errorCode = errorCode;
        this.log = log;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public boolean isLog() {
        return log;
    }

    @Override
    public String toString() {
        String s = getClass().getName();
        String message = getLocalizedMessage();
        // BizResponseException: ATTR_NOT_FOUND: attribute not found
        return s + ": " + errorCode.getRespCode() + ": " + message;
    }
}
