package com.valor.vod.common.web.tools;

import common.config.tools.config.ConfigTools3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Arvin Zhang
 * @Description: Business exception for all business process processing failed.
 * @date 2019/7/2 15:03
 **/
public class BusinessException extends Exception {

    private static final long serialVersionUID = 7918504628536752776L;

    private static final Logger log = LoggerFactory.getLogger(BusinessException.class);
    private int retCode;
    private int errCode;
    private String language = "en";

    public BusinessException(String language, int retCode, int errCode, String msg) {
        super(msg);
        this.retCode = retCode;
        this.errCode = errCode;
        this.language = language;
    }

    public BusinessException(String language, int retCode, int errCode) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.language = language;
    }

    public BusinessException(int retCode, int errCode, String msg) {
        super(msg);
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public BusinessException(int retCode, int errCode) {
        this.retCode = retCode;
        this.errCode = errCode;
    }

    //Thrown runtime exception when use lambda.
    public static <E extends Exception> void lambdaThrowException(Exception e) throws E {
        throw (E) e;
    }

    public int getRetCode() {
        return retCode;
    }

    public int getErrCode() {
        return errCode;
    }

    public String getErrorMessage() {
        //get Muti-language error message , if not found , English message will be used.
        return ConfigTools3.getString(language + "." + retCode + "." + errCode,
            ConfigTools3.getString("en." + retCode + "." + errCode, ""));
    }

}
