package com.valor.vod.common.web.tools;

import org.slf4j.Logger;

import java.util.LinkedHashMap;
import java.util.Map;

public class LogJson {

    private static String buildLogStr(String description, Object... entries) {
        Map<String, Object> maps = new LinkedHashMap<>();
        maps.put("msg", description);
        for (int i = 0; i < entries.length; i = i + 2) {
            String key = String.valueOf(entries[i]);
            Object value;
            if (i + 1 >= entries.length) {
                value = "";
            } else {
                value = entries[i + 1];
            }
            maps.put(key, value);
        }
        return GsonUtils.getString(maps);
    }

    public static void info(Logger logger, String description, Object... entries) {
        logger.info(buildLogStr(description, entries));
    }

    public static void warn(Logger logger, String description, Object... entries) {
        logger.warn(buildLogStr(description, entries));
    }

    public static void error(
            Logger logger, Throwable throwable, String description, Object... entries) {
        logger.error(buildLogStr(description, entries), throwable);
    }

    public static void error(Logger logger, String description, Object... entries) {
        logger.error(buildLogStr(description, entries));
    }
}
