package com.valor.vod.common.web.tools;

import com.google.common.base.Strings;
import com.valor.vod.common.web.constant.VodHttpAttr;
import common.config.tools.config.ConfigTools3;

import java.util.List;
import java.util.Map;

/**
 * @author Darby
 */
public class VodConfigTools {

    public static final String DOT = ".";
    public static final String DEFAULT_BRAND = "mfc";

    public static String transferKey(String key) {
        String brand = VodHttpContext.getContext().getString(VodHttpAttr.BRAND, null);
        if (Strings.isNullOrEmpty(brand)){
            return DEFAULT_BRAND + DOT + key;
        }
        return brand + DOT + key;
    }

    public static Long getLong(String key, Long defaultValue) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getLong(key, defaultValue) : ConfigTools3.getLong(tenantKey);
    }

    public static Long getLong(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getLong(key) : ConfigTools3.getLong(tenantKey);
    }

    public static Long getConfigAsLong(String key, Long defaultValue) {
        return getLong(key, defaultValue);
    }

    public static Long getConfigAsLong(String key) {
        return getLong(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getInt(key, defaultValue) : ConfigTools3.getInt(tenantKey);
    }

    public static Integer getInt(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getInt(key) : ConfigTools3.getInt(tenantKey);
    }

    public static Integer getConfigAsInt(String key, Integer defaultValue) {
        return getInt(key, defaultValue);
    }

    public static Integer getConfigAsInt(String key) {
        return getInt(key);
    }

    public static String getString(String key, String defaultValue) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getString(key, defaultValue) : ConfigTools3.getString(tenantKey);
    }

    public static String getString(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getString(key) : ConfigTools3.getString(tenantKey);
    }

    public static String getConfigAsString(String key, String defaultValue) {
        return getString(key, defaultValue);
    }

    public static String getConfigAsString(String key) {
        return getString(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getBoolean(key, defaultValue) : ConfigTools3.getBoolean(tenantKey);
    }

    public static boolean getBoolean(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getBoolean(key) : ConfigTools3.getBoolean(tenantKey);
    }

    public static boolean getAsBoolean(String key, boolean defaultValue) {
        return getBoolean(key, defaultValue);
    }

    public static boolean getAsBoolean(String key) {
        return getBoolean(key);
    }

    public static List<String> getAsList(String key, String split) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getAsList(key, split) : ConfigTools3.getAsList(tenantKey, split);
    }

    public static List<String> getAsList(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getAsList(key) : ConfigTools3.getAsList(tenantKey);
    }

    public static Map<String, String> getAsMap(String key, String itemSeparator, String keyValueSeparator) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getAsMap(key, itemSeparator, keyValueSeparator) : ConfigTools3.getAsMap(tenantKey, itemSeparator, keyValueSeparator);
    }

    public static Map<String, String> getAsMap(String key) {
        String tenantKey = transferKey(key);
        return Strings.isNullOrEmpty(ConfigTools3.getString(tenantKey)) ?
                ConfigTools3.getAsMap(key, "&", "=") : ConfigTools3.getAsMap(tenantKey, "&", "=");
    }

    public static void load(String dir) {
        ConfigTools3.load(dir);
    }
}
