/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.common.web.aop.annotation.InterfaceLog;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InterfaceLogAspect {
    private static final Logger log = LoggerFactory.getLogger(InterfaceLogAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.valor.vod.common.web.aop.annotation.InterfaceLog) && @annotation(annotation)")
    public Object log(ProceedingJoinPoint pjp, InterfaceLog annotation) throws Throwable {
        Object object;
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        log.info("{}.{} start. {}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), this.getParamString(method, pjp.getArgs())});
        Object returnValue = null;
        try {
            object = returnValue = pjp.proceed();
        }
        catch (Throwable throwable) {
            log.info("{}.{} end. returnValue[{}]", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), returnValue});
            throw throwable;
        }
        log.info("{}.{} end. returnValue[{}]", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), returnValue});
        return object;
    }

    private String getParamString(Method method, Object[] args) {
        DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        if (parameterNames == null || parameterNames.length == 0) {
            return "";
        }
        StringBuilder messageBuilder = new StringBuilder(64);
        for (int i = 0; i < parameterNames.length; ++i) {
            messageBuilder.append(' ').append(parameterNames[i]).append('[').append(args[i]).append("]").append(i == parameterNames.length - 1 ? (char)'.' : ',');
        }
        return messageBuilder.toString();
    }
}

