/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.common.web.tools.GsonUtils;
import com.valor.vod.common.web.tools.VodException;
import common.base.tools.exception.ApiException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RequestClientAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestClientAspect.class);

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.RequestClient) || @within(com.valor.vod.common.web.aop.annotation.RequestClient)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object requestClient(ProceedingJoinPoint pjp) throws Throwable {
        String methodName = pjp.getSignature().getName();
        Object[] args = pjp.getArgs();
        Object response = null;
        long startTime = System.currentTimeMillis();
        Exception ex = null;
        try {
            response = pjp.proceed();
        }
        catch (Exception e2) {
            ex = e2;
        }
        if (ex != null) {
            if (ex instanceof VodException) {
                VodException vodEx = (VodException)ex;
                String codeMsg = String.format("retCode=%d errCode=%d errMessage=%s", vodEx.getRetCode(), vodEx.getErrCode(), vodEx.getMessage());
                log.error("client-err: method=>[{}] request={} {}", new Object[]{methodName, args, codeMsg});
            } else if (ex instanceof ApiException) {
                ApiException apiEx = (ApiException)ex;
                String codeMsg = String.format("retCode=%d errCode=%d errMessage=%s", apiEx.getRetCode(), apiEx.getErrCode(), apiEx.getMessage());
                log.error("client-err: method=>[{}] request={} {}", new Object[]{methodName, args, codeMsg});
            } else {
                log.error("client-err: method=>[{}] request={} ", new Object[]{methodName, args, ex});
            }
            throw ex;
        }
        long endTime = System.currentTimeMillis();
        log.info("client-suc: method=>[{}], request={}, response={} cost={}", new Object[]{methodName, args, GsonUtils.getString(response), endTime - startTime});
        return response;
    }
}

