/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.common.web.aop.annotation.ValidParameter;
import com.valor.vod.common.web.tools.VodException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Aspect
@Order(value=2)
public class ValidatorAspect {
    private Validator validator;

    public ValidatorAspect(Validator validator) {
        this.validator = validator;
    }

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.ValidParameter)")
    public void validParamPointcut() {
    }

    @Around(value="validParamPointcut() && @annotation(validParameter)")
    public Object validation(ProceedingJoinPoint pjp, ValidParameter validParameter) throws Throwable {
        Object[] args = pjp.getArgs();
        boolean tx = false;
        String language = null;
        for (Object arg : args) {
            Object lan;
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse) continue;
            try {
                lan = MethodUtils.invokeMethod((Object)arg, (String)"getLanguage");
                if (lan != null && StringUtils.hasText((String)lan.toString())) {
                    language = lan.toString();
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                lan = MethodUtils.invokeMethod((Object)arg, (String)"getLang");
                if (lan == null || !StringUtils.hasText((String)lan.toString())) continue;
                language = lan.toString();
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!StringUtils.hasText(language)) {
            language = "en";
        }
        Locale locale = StringUtils.parseLocale((String)language);
        LocaleContextHolder.setLocale((Locale)locale);
        String errorMessage = "";
        for (Object arg : args) {
            Set set;
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse || !Objects.nonNull(set = this.validator.validate(arg, (Class[])validParameter.groups())) || set.size() <= 0) continue;
            ConstraintViolation constraintViolation = (ConstraintViolation)set.stream().findFirst().get();
            errorMessage = constraintViolation.getMessage();
            tx = true;
            break;
        }
        if (tx) {
            throw VodException.builder().language(locale.getLanguage()).retCode(3).errCode(250).message(errorMessage).build();
        }
        return pjp.proceed();
    }
}

