/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.api.model.user.EAccountType;
import com.valor.vod.common.web.aop.processor.VerifySessionInterceptor;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.constant.VodHttpAttr;
import com.valor.vod.common.web.http.CommonServiceApi;
import com.valor.vod.common.web.model.BaseResponse;
import com.valor.vod.common.web.tools.VodHttpContext;
import common.base.tools.api.model.ApiBaseResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class VerifySDKSessionInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(VerifySessionInterceptor.class);
    private static final String MOBILE = "mobile";
    private static final String BOX = "box";
    @Autowired
    private CommonServiceApi commonServiceApi;

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.VerifySDKSession)")
    public void verifySDKSession() {
    }

    @Around(value="com.valor.vod.common.web.aop.processor.VerifySDKSessionInterceptor.verifySDKSession()")
    public Object doVerifySession(ProceedingJoinPoint pjp) throws Throwable {
        Object args = this.getArgs((JoinPoint)pjp);
        Object proceed = pjp.proceed();
        String clientSession = VodHttpContext.getContext().getString(VodHttpAttr.CLIENT_SESSION);
        Long accountId = VodHttpContext.getContext().getLong(VodHttpAttr.ACCOUNT_ID);
        String appId = VodHttpContext.getContext().getString(VodHttpAttr.APP_ID);
        int accountType = VodHttpContext.getContext().getInteger(VodHttpAttr.ACCOUNT_TYPE);
        if (Objects.nonNull(args) && StringUtils.isNotEmpty((CharSequence)appId) && appId.equalsIgnoreCase("mfc-kids")) {
            if (!this.isAppRequest()) {
                logger.info("Kids account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ", new Object[]{accountId, accountType, clientSession, this.isAppRequest(), accountType == EAccountType.DEVICE.getCode()});
            }
        } else if (this.isAppRequest()) {
            ApiBaseResponse result = this.commonServiceApi.checkSession(accountId, accountType, clientSession, null);
            if (result.getErrCode() != 0) {
                if (proceed instanceof BaseResponse) {
                    BaseResponse responseStatus = (BaseResponse)proceed;
                    responseStatus.setCode(SystemErrorCodes.SESSION_OFFLINE.getCode());
                    responseStatus.setMsg(SystemErrorCodes.SESSION_OFFLINE.getDesc());
                }
                logger.info("Account[{}] accountType[{}] session[{}] , session is not online ", new Object[]{accountId, accountType, clientSession});
            } else {
                logger.debug("Account[{}] accountType[{}] session[{}] , session is online ", new Object[]{accountId, accountType, clientSession});
            }
        } else {
            logger.info("Account[{}] accountType[{}] session[{}] app[{}] device[{}] , don't check session ! ", new Object[]{accountId, accountType, clientSession, this.isAppRequest(), accountType == EAccountType.DEVICE.getCode()});
        }
        return proceed;
    }

    public Object getArgs(JoinPoint jp) {
        Object arg = null;
        if (jp.getArgs().length >= 3) {
            arg = jp.getArgs()[2];
            return arg;
        }
        return null;
    }

    private boolean isAppRequest() {
        String appId = VodHttpContext.getContext().getString(VodHttpAttr.APP_ID);
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return false;
        }
        return appId.equalsIgnoreCase(MOBILE) || appId.equalsIgnoreCase(BOX);
    }
}

