/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.aop.processor;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.aop.annotation.WebApiCallV1;
import com.valor.vod.common.web.request.IRequestArgs;
import com.valor.vod.common.web.tools.VodException;
import com.valor.vod.common.web.util.TraceContext;
import com.valor.vod.common.web.util.UuidGenerator;
import common.base.tools.exception.ApiException;
import common.base.tools.statistics.CountStatisticsTools2;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Aspect
@Order(value=1)
public class WebApiCallInterceptorV1 {
    private static final Logger log = LoggerFactory.getLogger(WebApiCallInterceptorV1.class);

    @Pointcut(value="@annotation(com.valor.vod.common.web.aop.annotation.WebApiCallV1)")
    public void webApiCall() {
    }

    @Around(value="com.valor.vod.common.web.aop.processor.WebApiCallInterceptorV1.webApiCall()&&@annotation(wac)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiCallV1 wac) throws ServletException, IOException, ApiException {
        String apiName = this.getApiName((JoinPoint)pjp);
        String apiPath = this.getApiPath((JoinPoint)pjp);
        CountStatisticsTools2.addCount((String)apiName, (String)"REQ", (long)1L);
        HttpServletRequest request = this.getRequest((JoinPoint)pjp);
        HttpServletResponse response = this.getResponse((JoinPoint)pjp);
        String host = HttpTools.getRemoteHost((HttpServletRequest)request);
        this.setTraceId(request);
        IRequestArgs requestArgs = this.getArgs((JoinPoint)pjp);
        if (requestArgs != null) {
            requestArgs.setArgsFromParameter(request);
        }
        this.logRequest(wac, host, apiName, requestArgs);
        try {
            Long appVer;
            if (this.getMinVersion(wac, apiName) > 0 && ((appVer = HttpTools.getLongParameter((HttpServletRequest)request, (String)"appVer")) == null || appVer < (long)this.getMinVersion(wac, apiName))) {
                throw new ApiException(6, 400, apiPath, "Unsupported version");
            }
            Object retVal = pjp.proceed();
            HttpTools.updateSrvInfo((HttpServletRequest)request, (Object)retVal);
            boolean isSuccess = this.isSuccess(retVal);
            if (isSuccess) {
                CountStatisticsTools2.addCount((String)apiName, (String)"RSP", (long)1L);
                if (this.getCacheControl(wac, apiName) > 0) {
                    this.getResponse((JoinPoint)pjp).setHeader("Cache-Control", "max-age=" + wac.cacheControl());
                    this.getResponse((JoinPoint)pjp).setHeader("cache_interval_time", "" + this.getCacheControl(wac, apiName));
                    this.getResponse((JoinPoint)pjp).setHeader("cache_allow_save", "1");
                }
            } else {
                response.setStatus(555);
                CountStatisticsTools2.addCount((String)apiName, (String)"ERR", (long)1L);
            }
            if (isSuccess) {
                this.logResponse(wac, host, apiName, retVal, requestArgs);
            } else {
                this.logResponse(false, host, apiName, retVal, requestArgs);
            }
            this.addTraceIdToRetVal(retVal);
            TraceContext.removeTraceId();
            return retVal;
        }
        catch (VodException | UndeclaredThrowableException e2) {
            throw e2;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ApiException) {
                throw (ApiException)throwable;
            }
            log.error("API:[{}]", (Object)apiName, (Object)throwable);
            throw new ApiException(1, 101, "Internal error");
        }
    }

    private void setTraceId(HttpServletRequest request) {
        String traceId = request.getHeader("traceId");
        if (traceId == null) {
            traceId = UuidGenerator.newUuid();
        }
        TraceContext.setTraceId(traceId);
    }

    private void addTraceIdToRetVal(Object retVal) {
        if (!(retVal instanceof ResponseStatus)) {
            return;
        }
        ((ResponseStatus)retVal).setTraceId(TraceContext.getTraceId());
    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof HttpServletRequest)) continue;
            return (HttpServletRequest)arg;
        }
        return null;
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof HttpServletResponse)) continue;
            return (HttpServletResponse)arg;
        }
        return null;
    }

    public IRequestArgs getArgs(JoinPoint jp) {
        for (Object arg : jp.getArgs()) {
            if (!(arg instanceof IRequestArgs)) continue;
            return (IRequestArgs)arg;
        }
        return null;
    }

    public String getApiName(JoinPoint jp) {
        String apiName = this.getRequest(jp).getRequestURI();
        apiName = apiName.substring(1).replace("/", "-");
        return apiName;
    }

    public String getApiPath(JoinPoint jp) {
        return this.getRequest(jp).getRequestURI();
    }

    private void logRequest(WebApiCallV1 webApiCall, String host, String apiName, IRequestArgs args) {
        if (this.getLogLevel(webApiCall, apiName, "request") == 0) {
            return;
        }
        this.logReq(host, apiName, this.obj2String(args));
    }

    private void logResponse(WebApiCallV1 webApiCall, String host, String apiName, Object result, IRequestArgs iArgs) {
        if (this.getLogLevel(webApiCall, apiName, "response") == 0) {
            return;
        }
        this.logResponse(true, host, apiName, result, iArgs);
    }

    private void logResponse(boolean isSuccess, String host, String apiName, Object result, IRequestArgs iArgs) {
        if (isSuccess) {
            this.logRsp(host, apiName, this.obj2String(iArgs), this.obj2String(result));
        } else {
            this.logErrRsp(host, apiName, this.obj2String(iArgs), this.obj2String(result));
        }
    }

    private boolean isSuccess(Object result) {
        if (result instanceof ResponseStatus) {
            return ((ResponseStatus)result).getRetCode() == 0;
        }
        return false;
    }

    private int getMinVersion(WebApiCallV1 webApiCall, String apiName) {
        String minVerKey = "webapi.version.min";
        String apiVerKey = String.format("%s.%s", "webapi.version.min", apiName);
        int minVersion = ConfigTools3.getInt((String)apiVerKey, (Integer)ConfigTools3.getInt((String)"webapi.version.min", (Integer)0));
        if (minVersion == 0) {
            minVersion = webApiCall.minVersion();
        }
        return minVersion;
    }

    private int getLogLevel(WebApiCallV1 webApiCall, String apiName, String msgType) {
        String defaultKey = "webapi.log.level";
        String apiMsgKey = String.format("%s.%s.%s", "webapi.log.level", msgType, apiName);
        String apiKey = String.format("%s.%s", "webapi.log.level", apiName);
        int value = ConfigTools3.getInt((String)apiMsgKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)apiKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)"webapi.log.level", (Integer)0);
        if (value != 0) {
            return value;
        }
        value = webApiCall.logLevel();
        return value;
    }

    private int getCacheControl(WebApiCallV1 webApiCall, String apiName) {
        String defaultKey = "webapi.cache.control";
        String apiKey = "webapi.cache.control." + apiName;
        int value = ConfigTools3.getInt((String)apiKey, (Integer)0);
        if (value != 0) {
            return value;
        }
        value = ConfigTools3.getInt((String)"webapi.cache.control", (Integer)0);
        if (value != 0) {
            return value;
        }
        return webApiCall.cacheControl();
    }

    private String obj2String(Object obj) {
        if (obj == null) {
            return "-";
        }
        return obj.toString();
    }

    private void logReq(String host, String apiName, String request) {
        log.info("[REQ] [HOST]:[{}] [API]:[{}]req[{}]", new Object[]{host, apiName, request});
    }

    private void logRsp(String host, String apiName, String request, String response) {
        log.info("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, request});
    }

    private void logErrRsp(String host, String apiName, String request, String response) {
        log.error("[RSP] [HOST]:[{}] [API]:[{}] Resp[{}] req[{}]", new Object[]{host, apiName, response, request});
    }
}

