/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.configuration;

import com.valor.vod.common.web.constant.ErrorCode;
import com.valor.vod.common.web.constant.ProjectModule;
import com.valor.vod.common.web.tools.ErrorCodeException;
import com.valor.vod.common.web.tools.ErrorManager;
import java.io.IOException;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathErrorCodeScanner
implements EnvironmentAware,
ResourceLoaderAware {
    static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private String resourcePattern = "**/*.class";
    private Environment environment;
    private ResourcePatternResolver resourcePatternResolver;
    private MetadataReaderFactory metadataReaderFactory;
    private final TypeFilter enumFilter;
    private final TypeFilter errorCodeFilter = new AssignableTypeFilter(ErrorCode.class);
    private final TypeFilter projectModuleFilter = new AssignableTypeFilter(ProjectModule.class);

    public ClassPathErrorCodeScanner() {
        this.enumFilter = new AssignableTypeFilter(Enum.class);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourcePattern(String resourcePattern) {
        this.resourcePattern = resourcePattern;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void scan(String ... basePackages) {
        for (String basePackage : basePackages) {
            this.doScan(basePackage);
        }
    }

    protected void doScan(String basePackage) {
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + '/' + this.resourcePattern;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                try {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                    if (this.projectModuleFilter.match(metadataReader, this.metadataReaderFactory)) {
                        this.registerProjectModule(metadataReader, this.metadataReaderFactory);
                        continue;
                    }
                    if (!this.errorCodeFilter.match(metadataReader, this.metadataReaderFactory)) continue;
                    this.registerErrorCode(metadataReader, this.metadataReaderFactory);
                }
                catch (Exception e) {
                    throw new ErrorCodeException("Unexpected failure during register", e);
                }
            }
        }
        catch (IOException e) {
            throw new ErrorCodeException("I/O failure during classpath scanning", e);
        }
    }

    protected String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)this.getEnvironment().resolveRequiredPlaceholders(basePackage));
    }

    private void registerProjectModule(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws Exception {
        if (this.enumFilter.match(metadataReader, metadataReaderFactory)) {
            Class clazz = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            for (Object o : clazz.getEnumConstants()) {
                ErrorManager.register((ProjectModule)o);
            }
        }
    }

    private void registerErrorCode(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws Exception {
        if (this.enumFilter.match(metadataReader, metadataReaderFactory)) {
            Class clazz = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            for (Object o : clazz.getEnumConstants()) {
                ErrorManager.register((ErrorCode)o);
            }
        }
    }
}

