/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.configuration;

import com.valor.vod.common.web.configuration.ClassPathErrorCodeScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ErrorCodeScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware,
InitializingBean {
    private String basePackage;
    private ApplicationContext applicationContext;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)StringUtils.hasLength((String)this.basePackage), (String)"Error code scan package is empty");
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ClassPathErrorCodeScanner scanner = new ClassPathErrorCodeScanner();
        scanner.setEnvironment(this.applicationContext.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }
}

