/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.configuration;

import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.constant.VodHttpAttr;
import com.valor.vod.common.web.constant.VodHttpHeader;
import com.valor.vod.common.web.tools.VodHttpContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HeaderExtractHandlerInterceptor
implements HandlerInterceptor {
    private Map<String, String> extractHeaders;

    public HeaderExtractHandlerInterceptor(Map<String, String> extractHeaders) {
        this.extractHeaders = extractHeaders;
    }

    public HeaderExtractHandlerInterceptor() {
        this(Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        void var5_9;
        VodHttpContext.getContext().removeAll();
        if (this.extractHeaders != null && !this.extractHeaders.isEmpty()) {
            for (Map.Entry entry : this.extractHeaders.entrySet()) {
                String val = request.getHeader((String)entry.getKey());
                if (val == null) continue;
                VodHttpContext.getContext().set(VodHttpAttr.valueOf((String)entry.getValue()), val);
            }
        }
        for (VodHttpHeader header : VodHttpHeader.values()) {
            Object val = request.getHeader(header.getHeaderName());
            if (val == null) {
                val = request.getAttribute(header.getAttr().getName());
            }
            if (val == null) continue;
            VodHttpContext.getContext().set(header.getAttr(), val);
        }
        String acceptLanguage = request.getHeader("Accept-Language");
        Locale locale = Locale.ENGLISH;
        if (StringUtils.hasText((String)acceptLanguage)) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Accept-Language", acceptLanguage);
            List locales = httpHeaders.getAcceptLanguageAsLocales();
            if (!CollectionUtils.isEmpty((Collection)locales)) {
                Locale locale2 = (Locale)locales.get(0);
            }
        }
        VodHttpContext.getContext().set(VodHttpAttr.LANGUAGE, var5_9.getLanguage());
        String clientIp = HttpTools.getRemoteHost((HttpServletRequest)request);
        VodHttpContext.getContext().set(VodHttpAttr.CLIENT_IP, clientIp);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String cryptVerHeaderName = "Vod-CryptVer";
        String cryptVer = request.getHeader(cryptVerHeaderName);
        if (StringUtils.hasText((String)cryptVer)) {
            response.setHeader(cryptVerHeaderName, cryptVer);
        }
        response.setHeader("X-Sw-Trace-Id", TraceContext.traceId());
        VodHttpContext.getContext().removeAll();
    }
}

