/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.configuration;

import com.valor.vod.common.web.aop.processor.RequestClientAspect;
import com.valor.vod.common.web.aop.processor.ValidatorAspect;
import com.valor.vod.common.web.aop.processor.VerifySDKSessionInterceptor;
import com.valor.vod.common.web.aop.processor.VerifySessionInterceptor;
import com.valor.vod.common.web.configuration.ClassPathErrorCodeScanner;
import com.valor.vod.common.web.configuration.ErrorCodeScannerConfigurer;
import com.valor.vod.common.web.configuration.HeaderExtractHandlerInterceptor;
import com.valor.vod.common.web.configuration.VodCommonWebProperties;
import com.valor.vod.common.web.http.CommonServiceApi;
import common.config.tools.config.ConfigTools3;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={VodCommonWebProperties.class})
@ComponentScan(basePackages={"com.valor.vod.common.web"})
public class VodCommonWebConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(VodCommonWebConfiguration.class);

    @Configuration
    @ConditionalOnProperty(prefix="vod.common.web.verify-session", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class VodCommonWebVerifySessionConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={CommonServiceApi.class})
        public CommonServiceApi commonServiceApi() {
            return new CommonServiceApi();
        }

        @Bean
        @ConditionalOnMissingBean(value={VerifySessionInterceptor.class})
        public VerifySessionInterceptor verifySessionInterceptor() {
            return new VerifySessionInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(value={VerifySDKSessionInterceptor.class})
        public VerifySDKSessionInterceptor verifySDKSessionInterceptor() {
            return new VerifySDKSessionInterceptor();
        }
    }

    @Configuration
    @EnableWebMvc
    @EnableConfigurationProperties(value={VodCommonWebProperties.class})
    @AutoConfigureAfter(value={VodCommonWebValidatorConfiguration.class})
    public static class VodCommonWebMvcConfig
    implements WebMvcConfigurer {
        LocalValidatorFactoryBean vcmValidator;
        VodCommonWebProperties properties;

        @Autowired
        public void setProperties(VodCommonWebProperties properties) {
            this.properties = properties;
        }

        @Autowired(required=false)
        @Qualifier(value="vcmValidator")
        public void setVcmValidator(LocalValidatorFactoryBean vcmValidator) {
            this.vcmValidator = vcmValidator;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new HeaderExtractHandlerInterceptor(this.properties.getExtractHeaders()));
        }

        public org.springframework.validation.Validator getValidator() {
            return this.vcmValidator;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ErrorCodeScannerConfigurer.class})
    @AutoConfigureAfter
    public static class ErrorCodeScannerRegistrarNotFoundConfiguration
    implements InitializingBean,
    ApplicationContextAware {
        private ApplicationContext applicationContext;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public void afterPropertiesSet() {
            logger.debug("Not found configuration for registering error code bean using @ErrorCodeScan");
            if (!AutoConfigurationPackages.has((BeanFactory)this.applicationContext)) {
                return;
            }
            List packages = AutoConfigurationPackages.get((BeanFactory)this.applicationContext);
            if (CollectionUtils.isEmpty((Collection)packages)) {
                return;
            }
            ClassPathErrorCodeScanner scanner = new ClassPathErrorCodeScanner();
            scanner.setResourceLoader((ResourceLoader)this.applicationContext);
            scanner.setEnvironment(this.applicationContext.getEnvironment());
            scanner.scan(packages.toArray(new String[0]));
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="vod.common.web.request-client", value={"enabled"}, havingValue="true")
    public static class VodCommonWebRequestClientConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={RequestClientAspect.class})
        public RequestClientAspect vcmRequestClientAspect() {
            return new RequestClientAspect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ExecutableValidator.class})
    @ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
    @AutoConfigureBefore(value={VodCommonWebMvcConfig.class})
    public static class VodCommonWebValidatorConfiguration {
        @Bean
        public LocalValidatorFactoryBean vcmValidator() {
            LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
            localValidatorFactoryBean.getValidationPropertyMap().put("hibernate.validator.fail_fast", "true");
            localValidatorFactoryBean.setValidationMessageSource((MessageSource)this.vcmConfigMessageSource());
            return localValidatorFactoryBean;
        }

        @Bean
        @ConditionalOnMissingBean(value={ValidatorAspect.class})
        @ConditionalOnProperty(prefix="vod.common.web.valid-parameter", value={"enabled"}, havingValue="true")
        public ValidatorAspect vcmValidatorAspect() {
            return new ValidatorAspect((Validator)this.vcmValidator());
        }

        @Bean
        public ConfigMessageSource vcmConfigMessageSource() {
            return new ConfigMessageSource();
        }
    }

    public static class ConfigMessageSource
    extends AbstractMessageSource {
        protected MessageFormat resolveCode(String code, Locale locale) {
            String cfgKey = locale.getLanguage() + "." + code;
            String format = ConfigTools3.getString((String)cfgKey);
            return new MessageFormat(format);
        }
    }
}

