/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.constant;

import com.valor.vod.common.web.constant.ErrorCode;
import com.valor.vod.common.web.constant.ProjectModule;
import com.valor.vod.common.web.constant.SystemProjectModules;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum SystemErrorCodes implements ErrorCode
{
    OK(SystemProjectModules.COMMON, 200, "00000", "ok"),
    ATTR_NOT_FOUND(SystemProjectModules.COMMON, 500, "99996", "Attribute not found"),
    UNAUTHORIZED(SystemProjectModules.COMMON, 401, "99997", "Please login"),
    PARAM_INVALID(SystemProjectModules.COMMON, 400, "99998", "Invalid parameter"),
    SESSION_OFFLINE(SystemProjectModules.COMMON, 400, "225", "Invalid session , user is not online"),
    SYSTEM_ERROR(SystemProjectModules.COMMON, 500, "99999", "Internal Server Error");

    private final ProjectModule projectModule;
    private final int httpCode;
    private final String code;
    private final String desc;
    private static final Map<Integer, SystemErrorCodes> RET_CODE_MAP;

    private SystemErrorCodes(ProjectModule projectModule, int httpCode, String code, String desc) {
        this.projectModule = projectModule;
        this.httpCode = httpCode;
        this.code = code;
        this.desc = desc;
    }

    public static boolean contains(ErrorCode errorCode) {
        for (SystemErrorCodes e2 : SystemErrorCodes.values()) {
            if (!Objects.equals(e2, errorCode)) continue;
            return true;
        }
        return false;
    }

    public static SystemErrorCodes getByRetCode(int retCode) {
        return RET_CODE_MAP.getOrDefault(retCode, SYSTEM_ERROR);
    }

    @Override
    public ProjectModule getProjectModule() {
        return this.projectModule;
    }

    @Override
    public int getHttpCode() {
        return this.httpCode;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    static {
        RET_CODE_MAP = new HashMap<Integer, SystemErrorCodes>();
        RET_CODE_MAP.put(0, OK);
        RET_CODE_MAP.put(2, UNAUTHORIZED);
        RET_CODE_MAP.put(3, PARAM_INVALID);
        RET_CODE_MAP.put(1, SYSTEM_ERROR);
    }
}

