/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.api.exception.ApiException;
import com.valor.vod.common.web.crypt.IjiamiSecurity;
import com.valor.vod.common.web.crypt.JaqSecurity;
import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptMsgTools {
    private static final Logger logger = LoggerFactory.getLogger(CryptMsgTools.class);
    private static final String ARG_AES_KEY_DEFAULT = "wqlnDJADUFnNRUn0fj2CXA";
    private static String CRYPT_ARG_AES_CONFIG_KEY = "mfc.api.arg.aes.key";
    private static String CRYPT_ARG_JAQ_CONFIG_KEY = "mfc.api.arg.jaq.key";
    private static String JAQ_APP_KEY_DEFAULT = "8ff9f0db-6f7b-4492-98c1-8226f81956eb";

    public static String decryptArg(String prot, String msg, String signature) throws Exception {
        if (Strings.isNullOrEmpty((String)msg)) {
            logger.error("Decrypt msg is empty");
            return "";
        }
        try {
            if ("3".equals(prot)) {
                return AESUtils.decrypt((String)msg, (String)ConfigTools3.getString((String)CRYPT_ARG_AES_CONFIG_KEY, (String)ARG_AES_KEY_DEFAULT));
            }
            if ("4".equals(prot)) {
                boolean checked = JaqSecurity.checkSign(msg, ConfigTools3.getString((String)CRYPT_ARG_JAQ_CONFIG_KEY, (String)JAQ_APP_KEY_DEFAULT), signature);
                if (!checked) {
                    throw new ApiException(3, 305, "Args decrypt exception.");
                }
                byte[] decodeBytes = JaqSecurity.decrypt(msg.getBytes(), ConfigTools3.getString((String)CRYPT_ARG_JAQ_CONFIG_KEY, (String)JAQ_APP_KEY_DEFAULT));
                if (decodeBytes == null) {
                    return "";
                }
                return new String(decodeBytes);
            }
            if ("5".equals(prot)) {
                boolean checked = IjiamiSecurity.checkSign(msg, signature);
                if (!checked) {
                    throw new ApiException(3, 305, "Args decrypt exception.");
                }
                String decodeString = IjiamiSecurity.decryptString(msg);
                return decodeString;
            }
            throw new ApiException(3, 302, "Args decrypt exception.");
        }
        catch (Exception e2) {
            logger.error("Decode arg exception:{}", (Throwable)e2);
            if (e2 instanceof ApiException) {
                throw e2;
            }
            throw new ApiException(3, 303, "Args decrypt exception.");
        }
    }

    public static String encryptMsg(String prot, String msg) {
        if (Strings.isNullOrEmpty((String)msg)) {
            logger.error("Encrypt msg is empty");
            return "";
        }
        try {
            if ("3".equals(prot)) {
                return AESUtils.encrypt((String)msg, (String)ConfigTools3.getString((String)CRYPT_ARG_AES_CONFIG_KEY, (String)ARG_AES_KEY_DEFAULT));
            }
            if ("4".equals(prot)) {
                return JaqSecurity.encrypt(msg, ConfigTools3.getString((String)CRYPT_ARG_JAQ_CONFIG_KEY, (String)JAQ_APP_KEY_DEFAULT));
            }
            if ("5".equals(prot)) {
                return IjiamiSecurity.encryptString(msg);
            }
            return "";
        }
        catch (Exception e2) {
            logger.error("Encrypt arg exception:{}", (Throwable)e2);
            return "";
        }
    }

    public static String encryptMsg(String prot, byte[] msg) {
        return CryptMsgTools.encryptMsg(prot, new String(msg));
    }

    public static String getSign(String prot, String msg) {
        try {
            if ("4".equals(prot)) {
                return JaqSecurity.sign(msg, ConfigTools3.getString((String)CRYPT_ARG_JAQ_CONFIG_KEY, (String)JAQ_APP_KEY_DEFAULT));
            }
            if ("5".equals(prot)) {
                return IjiamiSecurity.sign(msg);
            }
            return "";
        }
        catch (Exception e2) {
            logger.error("Sign msg exception:{}", (Throwable)e2);
            return "";
        }
    }
}

