/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt;

import com.ijiami.JMEncryptBox;
import com.ijiami.LoadMessage;
import com.valor.vod.api.common.encrypt.SHA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IjiamiSecurity {
    private static final Logger logger = LoggerFactory.getLogger(IjiamiSecurity.class);
    private static int algorithmType = 1;
    private static boolean isLoadDllPath;

    public static synchronized void init(String cfgPath) {
        if (isLoadDllPath) {
            return;
        }
        LoadMessage loadMessage = new LoadMessage(){

            public void debugLoadMsg(String s) {
                logger.info(s);
            }
        };
        isLoadDllPath = JMEncryptBox.initLoadDllPath((String)cfgPath, (LoadMessage)loadMessage);
    }

    public static String encryptString(String plain) {
        logger.debug("encryptString plain[{}}", (Object)plain);
        String cipher = null;
        try {
            cipher = JMEncryptBox.encryptToBase64((String)plain, (int)algorithmType);
        }
        catch (Exception e2) {
            logger.error("encryptString plain exception:{}", (Throwable)e2);
        }
        logger.debug("encryptString cipher[{}}", (Object)plain);
        return cipher;
    }

    public static String decryptString(String cipher) {
        logger.debug("decryptString cipher[{}}", (Object)cipher);
        String plain = null;
        try {
            plain = JMEncryptBox.decryptFromBase64((String)cipher, (int)algorithmType).getText();
        }
        catch (Exception e2) {
            logger.error("decryptString cipher exception:{}", (Throwable)e2);
        }
        logger.debug("decryptString plain[{}}", (Object)plain);
        return plain;
    }

    public static boolean checkSign(String message, String signature) {
        String sign = IjiamiSecurity.sign(message);
        boolean pass = sign.equals(signature);
        logger.debug("checkSign message[{}},signature[{}],sign[{}],[{}]", new Object[]{message, signature, sign, pass});
        return pass;
    }

    public static String sign(String message) {
        return SHA.sha1((String)message);
    }
}

