/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.crypt;

import com.google.common.base.Strings;
import com.taobao.wsg.signcheck.CheckWithConfig;
import com.taobao.wsgsvr.SignCheckWithCfg;
import com.valor.vod.common.web.crypt.JaqSignWithCfg;
import java.security.Signature;

public class JaqSecurity {
    private static CheckWithConfig checkWithConfig = null;
    private static SignCheckWithCfg signCheckWithCfg = null;
    private static JaqSignWithCfg jaqSignWithCfg = null;
    private static Signature signature = null;
    private static String m_cfgPath;

    public static synchronized void init(String cfgPath) {
        if (checkWithConfig != null || signCheckWithCfg != null) {
            throw new IllegalStateException("Has init by cfg " + m_cfgPath);
        }
        try {
            checkWithConfig = new CheckWithConfig(cfgPath);
            signCheckWithCfg = new SignCheckWithCfg(cfgPath);
            jaqSignWithCfg = new JaqSignWithCfg(cfgPath);
            m_cfgPath = cfgPath;
        }
        catch (Exception e2) {
            throw new IllegalStateException("Init failed by cfg " + m_cfgPath, e2);
        }
    }

    public static byte[] encrypt(byte[] input, String jaqKey) {
        byte[] crypted = null;
        try {
            crypted = checkWithConfig.encrypt(input, jaqKey);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return crypted;
    }

    public static String encrypt(String input, String jaqKey) {
        try {
            if (!Strings.isNullOrEmpty((String)input)) {
                return checkWithConfig.encrypt(input, jaqKey);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return "";
    }

    public static String sign(String input, String jaqKey) {
        try {
            return jaqSignWithCfg.sign(input, jaqKey);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] input, String jaqKey) {
        try {
            byte[] output = checkWithConfig.decrypt(input, jaqKey);
            return output;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean checkSign(String input, String jaqKey, String sign) {
        try {
            return signCheckWithCfg.doSignCheck(input, jaqKey, sign);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }
}

