/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.valor.vod.common.tools.http.HttpParameterTools;
import com.valor.vod.common.tools.http.HttpTools;
import com.valor.vod.common.web.filter.sso.HeaderMapRequestWrapper;
import com.valor.vod.common.web.tools.VodException;
import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractSSOFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSSOFilter.class);
    protected String errorUrl = "";
    protected String excluded = "";
    protected int retcode = 2;
    protected int errcode = 0;
    protected String message = "Unauthorized";
    protected Set<String> excludedSet = Sets.newHashSet();

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }

    public String getExcluded() {
        return this.excluded;
    }

    public void setExcluded(String excluded) {
        this.excluded = excluded;
        try {
            this.excludedSet.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)excluded));
        }
        catch (Exception e2) {
            logger.error("{}", (Throwable)e2);
        }
    }

    public void addExcluded(String excluded) {
        if (!Strings.isNullOrEmpty((String)excluded)) {
            this.excludedSet.add(excluded);
        }
    }

    public Set<String> getExcludedSet() {
        return this.excludedSet;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        boolean isAllowRequest = false;
        String apiPath = HttpTools.getApiPath((HttpServletRequest)httpServletRequest);
        HeaderMapRequestWrapper requestWrapper = new HeaderMapRequestWrapper(httpServletRequest);
        if (this.isExclude(apiPath)) {
            isAllowRequest = true;
        } else {
            this.errcode = this.verify(requestWrapper);
            if (this.errcode == 0) {
                isAllowRequest = true;
            }
        }
        if (!isAllowRequest) {
            this.onError(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)httpServletResponse);
        }
    }

    public abstract String getToken(HttpServletRequest var1);

    public abstract byte[] decryptToken(String var1);

    public abstract Object getTokenObj(HttpServletRequest var1, byte[] var2);

    public abstract int verifyToken(HeaderMapRequestWrapper var1, Object var2);

    public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (Strings.isNullOrEmpty((String)this.errorUrl)) {
            throw VodException.builder().retCode(this.retcode).errCode(this.errcode).message(this.message).build();
        }
        httpServletRequest.setAttribute("_retcode", (Object)this.retcode);
        httpServletRequest.setAttribute("_errcode", (Object)this.errcode);
        httpServletRequest.setAttribute("_errmsg", (Object)this.message);
        httpServletRequest.setAttribute("_refer", (Object)HttpTools.getApiPath((HttpServletRequest)httpServletRequest));
        httpServletRequest.getServletContext().getRequestDispatcher(this.errorUrl).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public int verify(HeaderMapRequestWrapper httpRequest) {
        String host = HttpTools.getRemoteHost((HttpServletRequest)httpRequest);
        String did = Strings.nullToEmpty((String)HttpParameterTools.getParameter((HttpServletRequest)httpRequest, (String)"did"));
        String token = this.getToken((HttpServletRequest)httpRequest);
        if (Strings.isNullOrEmpty((String)token)) {
            logger.error("==========HOST:[{}] DID:[{}] Invalid token(empty)", (Object)host, (Object)did);
            this.errcode = 200;
            return this.errcode;
        }
        byte[] bytes = this.decryptToken(token);
        if (bytes.length == 0) {
            logger.error("==========HOST:[{}] DID:[{}] Invalid token:[{}]", new Object[]{host, did, token});
            this.errcode = 201;
            return this.errcode;
        }
        Object tokenObj = null;
        try {
            tokenObj = this.getTokenObj((HttpServletRequest)httpRequest, bytes);
        }
        catch (Exception e2) {
            logger.error("exception:", (Throwable)e2);
        }
        if (tokenObj == null) {
            logger.error("==========HOST:[{}] DID:[{}] Invalid token(convert token object exception):[{}]", new Object[]{host, did, token});
            this.errcode = 208;
            return this.errcode;
        }
        return this.verifyToken(httpRequest, tokenObj);
    }

    private boolean isExclude(String apiPath) {
        if (apiPath.endsWith("api/ping2")) {
            return true;
        }
        if (apiPath.endsWith("api/ping/v1")) {
            return true;
        }
        if (apiPath.endsWith("api/ns")) {
            return true;
        }
        if (apiPath.endsWith("loadPlaylistConfigs/v1")) {
            logger.info("ignore loadPlaylistConfigs authorize");
            return true;
        }
        if (apiPath.endsWith("api/uac/activate/v1")) {
            logger.info("api/uac/activate/v1");
            return true;
        }
        if (apiPath.endsWith("loadRedisData/v1")) {
            logger.info("ignore loadRedisData authorize");
            return true;
        }
        if (apiPath.endsWith("delOldData/v1")) {
            logger.info("ignore delOldData authorize");
            return true;
        }
        if (apiPath.endsWith("rating/add/v2") || apiPath.endsWith("rating/query")) {
            logger.info("ignore auth rating authorize");
            return true;
        }
        if (apiPath.startsWith("/api/cloudAcctBg")) {
            return true;
        }
        for (String e2 : this.getExcludedSet()) {
            if (!this.isExclude(e2, apiPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isExclude(String excludedPath, String apiPath) {
        if (excludedPath.endsWith("*")) {
            int pos = excludedPath.indexOf("*");
            if (pos > 0) {
                String excludePrefix = excludedPath.substring(0, pos);
                return apiPath.startsWith(excludePrefix);
            }
        } else {
            return excludedPath.equalsIgnoreCase(apiPath);
        }
        return false;
    }
}

