/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.filter.sso;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.valor.vod.api.common.client.IStringSerializable;
import com.valor.vod.common.web.filter.sso.AuthTokenFiled;
import com.valor.vod.common.web.filter.sso.TokenFiledTools;
import com.valor.vod.common.web.filter.sso.TokenV1;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;

public class TokenV2
implements IStringSerializable {
    public static final int TOKEN_FOR_WEB = 1;
    public static final int TOKEN_FOR_DEVICE = 2;
    public static final int TOKEN_FOR_ACCOUNT = 3;
    public static final int TOKEN_FOR_LOGINCODE = 4;
    public static final int V20170905 = 20170905;
    public static final int V20180808 = 20180808;
    private static final String FIELD_SEPARATOR = "#&#";
    private static final String KV_SEPARATOR = "#=#";
    private Map<Integer, Object> fieldMap = Maps.newTreeMap();

    public TokenV2() {
        this.put(AuthTokenFiled.VERSION, (Object)20180808);
    }

    public static TokenV2 valueOf(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("[TOKEN2] Empty.");
        }
        if (value.startsWith(String.valueOf(20170905))) {
            return TokenV2.parseToTokenV2(value);
        }
        Map filedDataMap = Splitter.on((String)FIELD_SEPARATOR).withKeyValueSeparator(KV_SEPARATOR).split((CharSequence)value);
        TokenV2 token = new TokenV2();
        filedDataMap.forEach((k, v) -> {
            AuthTokenFiled filed = AuthTokenFiled.valueOf(Integer.parseInt(k));
            if (filed != null) {
                token.put(filed, TokenFiledTools.getFieldValue(filed.ordinal(), v));
            }
        });
        if (token.getSign() != token.sign()) {
            throw new IllegalArgumentException("[TOKEN2] Invalid Sign");
        }
        return token;
    }

    private static TokenV2 parseToTokenV2(String value) {
        TokenV1 tokenV1 = TokenV1.valueOf(value);
        if (tokenV1 == null) {
            return null;
        }
        TokenV2 tokenV2 = new TokenV2();
        tokenV2.put(AuthTokenFiled.VERSION, (Object)tokenV1.getVersion());
        tokenV2.put(AuthTokenFiled.SIGN, (Object)tokenV1.getSign());
        tokenV2.put(AuthTokenFiled.CREATE_TIMESTAMP, (Object)tokenV1.getGenerateTimestamp());
        tokenV2.put(AuthTokenFiled.EXPIRE_TIMESTAMP, (Object)tokenV1.getExpireTimestamp());
        tokenV2.put(AuthTokenFiled.CLIENT_TYPE, (Object)tokenV1.getClientType());
        tokenV2.put(AuthTokenFiled.ACCOUNT_TYPE, (Object)tokenV1.getLoginType());
        tokenV2.put(AuthTokenFiled.ECHO_STR, (Object)tokenV1.getEchoStr());
        tokenV2.put(AuthTokenFiled.ACCOUNT_ID, (Object)tokenV1.getAccountId());
        tokenV2.put(AuthTokenFiled.DID, (Object)tokenV1.getDid());
        tokenV2.put(AuthTokenFiled.DEVICE_ID, (Object)tokenV1.getDid2());
        tokenV2.put(AuthTokenFiled.PROPERTIES, (Object)tokenV1.getUserProps());
        return tokenV2;
    }

    public static TokenV2 valueOf(byte[] bytes) {
        return TokenV2.valueOf(new String(bytes));
    }

    public void put(AuthTokenFiled filed, Object fieldValue) {
        this.fieldMap.put(filed.ordinal(), fieldValue);
    }

    public void put(String filedName, Object fieldValue) {
        AuthTokenFiled filed = AuthTokenFiled.valueOf(filedName);
        if (filed != null) {
            this.fieldMap.put(filed.ordinal(), fieldValue);
        }
    }

    public Object get(int filedName) {
        return this.fieldMap.get(filedName);
    }

    public Object get(String filedName) {
        AuthTokenFiled filed = AuthTokenFiled.valueOf(filedName);
        if (filed == null) {
            return null;
        }
        return this.fieldMap.get(filed.ordinal());
    }

    private String fields2String(Map<Integer, Object> fields) {
        return Joiner.on((String)FIELD_SEPARATOR).withKeyValueSeparator(KV_SEPARATOR).join(fields);
    }

    private String getSignStr() {
        TreeMap map = Maps.newTreeMap();
        this.fieldMap.forEach((k, v) -> {
            if (AuthTokenFiled.SIGN.ordinal() != k.intValue() && AuthTokenFiled.PRODUCT_ID.ordinal() != k.intValue() && AuthTokenFiled.ROOT_NODE_ID.ordinal() != k.intValue()) {
                map.put(k, v);
            }
        });
        return this.fields2String(map);
    }

    public long sign() {
        return Hashing.adler32().hashString((CharSequence)this.getSignStr(), Charsets.UTF_8).padToLong();
    }

    public String toSerializeString() {
        this.fieldMap.put(AuthTokenFiled.SIGN.ordinal(), this.sign());
        return this.fields2String(this.fieldMap);
    }

    public byte[] toSerializeBytes() {
        try {
            return this.toSerializeString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return new byte[0];
        }
    }

    public long getSign() {
        return (Long)this.fieldMap.getOrDefault(AuthTokenFiled.SIGN.ordinal(), 0L);
    }

    public void setSign(long sign) {
        this.put(AuthTokenFiled.SIGN, (Object)this.sign());
    }

    public int getVersion() {
        return (Integer)this.fieldMap.getOrDefault(AuthTokenFiled.VERSION.ordinal(), 0);
    }

    public void setVersion(int version) {
        this.put(AuthTokenFiled.VERSION, (Object)this.sign());
    }

    public Long getGenerateTimestamp() {
        return (Long)this.get(AuthTokenFiled.CREATE_TIMESTAMP.ordinal());
    }

    public void setGenerateTimestamp(Long generateTimestamp) {
        this.put(AuthTokenFiled.CREATE_TIMESTAMP, (Object)generateTimestamp);
    }

    public Long getExpireTimestamp() {
        return (Long)this.get(AuthTokenFiled.EXPIRE_TIMESTAMP.name());
    }

    public void setExpireTimestamp(Long expireTimestamp) {
        this.put(AuthTokenFiled.EXPIRE_TIMESTAMP.name(), (Object)expireTimestamp);
    }

    public int getClientType() {
        return (Integer)this.get(AuthTokenFiled.CLIENT_TYPE.name());
    }

    public void setClientType(int clientType) {
        this.put(AuthTokenFiled.CLIENT_TYPE.name(), (Object)clientType);
    }

    public String getEchoStr() {
        return (String)this.get(AuthTokenFiled.ECHO_STR.name());
    }

    public void setEchoStr(String echoStr) {
        this.put(AuthTokenFiled.CLIENT_TYPE.name(), (Object)echoStr);
    }

    public int getLoginType() {
        return (Integer)this.get(AuthTokenFiled.ACCOUNT_TYPE.name());
    }

    public void setLoginType(int loginType) {
        this.put(AuthTokenFiled.ACCOUNT_TYPE.name(), (Object)loginType);
    }

    public Long getAccountId() {
        return (long)((Long)this.get(AuthTokenFiled.ACCOUNT_ID.name()));
    }

    public void setAccountId(Long accountId) {
        this.put(AuthTokenFiled.ACCOUNT_ID.name(), (Object)accountId);
    }

    public Long getSubAccountId() {
        return (long)((Long)this.get(AuthTokenFiled.SUB_ACCOUNT_ID.name()));
    }

    public void setSubAccountId(Long accountId) {
        this.put(AuthTokenFiled.SUB_ACCOUNT_ID.name(), (Object)accountId);
    }

    public Long getUserProps() {
        return (long)((Long)this.get(AuthTokenFiled.PROPERTIES.name()));
    }

    public void setUserProps(Long userProps) {
        this.put(AuthTokenFiled.PROPERTIES.name(), (Object)userProps);
    }

    public String getDid() {
        return (String)this.get(AuthTokenFiled.DID.name());
    }

    public void setDid(String did) {
        this.put(AuthTokenFiled.DID.name(), (Object)did);
    }

    public long getDid2() {
        return (Long)this.get(AuthTokenFiled.DEVICE_ID.name());
    }

    public void setDid2(Long deviceId) {
        this.put(AuthTokenFiled.DEVICE_ID.name(), (Object)deviceId);
    }

    public String dump(boolean multiLine) {
        StringBuilder sb = new StringBuilder();
        this.fieldMap.forEach((k, v) -> {
            if (sb.length() != 0) {
                if (multiLine) {
                    sb.append(System.lineSeparator());
                } else {
                    sb.append("|");
                }
            }
            sb.append((Object)AuthTokenFiled.valueOf(k));
            sb.append("=");
            sb.append(v);
        });
        return sb.toString();
    }

    public Long getProductId() {
        return (long)((Long)this.get(AuthTokenFiled.PRODUCT_ID.name()));
    }

    public void setProductId(Long productId) {
        this.put(AuthTokenFiled.PRODUCT_ID.name(), (Object)productId);
    }

    public Long getRootNodeId() {
        return (long)((Long)this.get(AuthTokenFiled.ROOT_NODE_ID.name()));
    }

    public void setRootNodeId(Long rootNodeId) {
        this.put(AuthTokenFiled.ROOT_NODE_ID.name(), (Object)rootNodeId);
    }
}

