/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.model;

import java.io.Serializable;

public class Page
implements Serializable {
    protected int pageId = 1;
    protected int pageSize = 10;
    protected long count;
    protected int pages;
    protected boolean hasNext;

    public Page() {
    }

    public Page(int pageId, int pageSize) {
        this.pageId = pageId;
        this.pageSize = pageSize;
    }

    public Page(int pageId, int pageSize, long count) {
        this.pageId = pageId;
        this.pageSize = pageSize;
        this.setCount(count);
    }

    public void setCount(long count) {
        this.count = count;
        this.pages = (int)(count / (long)this.pageSize + (long)(count % (long)this.pageSize == 0L ? 0 : 1));
        this.hasNext = this.pageId < this.pages;
    }

    public int getPageStart() {
        return (this.pageId - 1) * this.pageSize;
    }

    public static Page from(Page from, long count) {
        Page page = new Page();
        page.setPageId(from.getPageId());
        page.setPageSize(from.getPageSize());
        page.setCount(count);
        return page;
    }

    public Page setPageId(int pageId) {
        this.pageId = pageId;
        return this;
    }

    public Page setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Page setPages(int pages) {
        this.pages = pages;
        return this;
    }

    public Page setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
        return this;
    }

    public int getPageId() {
        return this.pageId;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getCount() {
        return this.count;
    }

    public int getPages() {
        return this.pages;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }
}

