/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import common.config.tools.config.ConfigTools3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessException
extends Exception {
    private static final long serialVersionUID = 7918504628536752776L;
    private static final Logger log = LoggerFactory.getLogger(BusinessException.class);
    private int retCode;
    private int errCode;
    private String language = "en";

    public BusinessException(String language, int retCode, int errCode, String msg) {
        super(msg);
        this.retCode = retCode;
        this.errCode = errCode;
        this.language = language;
    }

    public BusinessException(String language, int retCode, int errCode) {
        this.retCode = retCode;
        this.errCode = errCode;
        this.language = language;
    }

    public BusinessException(int retCode, int errCode, String msg) {
        super(msg);
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public BusinessException(int retCode, int errCode) {
        this.retCode = retCode;
        this.errCode = errCode;
    }

    public static <E extends Exception> void lambdaThrowException(Exception e) throws E {
        throw e;
    }

    public int getRetCode() {
        return this.retCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrorMessage() {
        return ConfigTools3.getString((String)(this.language + "." + this.retCode + "." + this.errCode), (String)ConfigTools3.getString((String)("en." + this.retCode + "." + this.errCode), (String)""));
    }
}

