/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.common.web.constant.ErrorCode;
import com.valor.vod.common.web.constant.ProjectModule;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.constant.SystemProjectModules;
import com.valor.vod.common.web.tools.ErrorCodeException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ErrorManager {
    private static final Map<String, ProjectModule> PROJECT_MODULE_MAP = new ConcurrentHashMap<String, ProjectModule>();
    private static final Map<String, ErrorCode> ERROR_CODE_MAP = new ConcurrentHashMap<String, ErrorCode>();
    private static final int MIN_HTTP_CODE = 100;
    private static final int MAX_HTTP_CODE = 599;

    public static void register(ProjectModule projectModule) {
        if (projectModule == null) {
            throw new ErrorCodeException("ProjectModule is null");
        }
        String projectCode = projectModule.getProjectCode();
        String moduleCode = projectModule.getModuleCode();
        if (!SystemProjectModules.contains(projectModule)) {
            if (projectCode == null || (projectCode = projectCode.trim()).isEmpty()) {
                throw new ErrorCodeException(String.format("ProjectModule:[%s], projectCode is empty", projectModule));
            }
            if (moduleCode == null || (moduleCode = moduleCode.trim()).isEmpty()) {
                throw new ErrorCodeException(String.format("ProjectModule:[%s], moduleCode is empty", projectModule));
            }
        }
        PROJECT_MODULE_MAP.compute(ErrorManager.getRespCode(projectCode, moduleCode, null), (s, e) -> {
            if (e != null && !Objects.equals(e, projectModule)) {
                throw new ErrorCodeException(String.format("ProjectModule:[%s] in conflict with [%s]", projectModule, e));
            }
            return projectModule;
        });
    }

    public static void register(ErrorCode errorCode) {
        if (errorCode == null) {
            throw new ErrorCodeException("ErrorCode is null");
        }
        ProjectModule projectModule = errorCode.getProjectModule();
        if (projectModule == null) {
            throw new ErrorCodeException(String.format("ErrorCode:[%s], projectModule is null", errorCode));
        }
        String projectCode = projectModule.getProjectCode();
        String moduleCode = projectModule.getModuleCode();
        if (!SystemProjectModules.contains(projectModule) && null == ErrorManager.getProjectModule(projectCode, moduleCode)) {
            ErrorManager.register(projectModule);
        }
        String code = errorCode.getCode();
        if (!SystemErrorCodes.contains(errorCode) && (code == null || (code = code.trim()).isEmpty())) {
            throw new ErrorCodeException(String.format("ErrorCode:[%s], code is empty", errorCode));
        }
        if (errorCode.getHttpCode() < 100 || errorCode.getHttpCode() > 599) {
            throw new ErrorCodeException(String.format("ErrorCode:[%s], illegal http code", errorCode));
        }
        ERROR_CODE_MAP.compute(ErrorManager.getRespCode(projectCode, moduleCode, code), (s, e) -> {
            if (e != null && !Objects.equals(e, errorCode)) {
                throw new ErrorCodeException(String.format("ErrorCode:[%s] in conflict with [%s]", errorCode, e));
            }
            return errorCode;
        });
    }

    public static ProjectModule getProjectModule(String projectCode, String moduleCode) {
        if (projectCode == null || (projectCode = projectCode.trim()).isEmpty()) {
            throw new ErrorCodeException("ProjectCode is empty");
        }
        if (moduleCode == null || (moduleCode = moduleCode.trim()).isEmpty()) {
            throw new ErrorCodeException("ModuleCode is empty");
        }
        return PROJECT_MODULE_MAP.get(ErrorManager.getRespCode(projectCode, moduleCode, null));
    }

    public static ErrorCode getErrorCode(String projectCode, String moduleCode, String code) {
        ProjectModule projectModule = ErrorManager.getProjectModule(projectCode, moduleCode);
        if (projectModule == null) {
            return null;
        }
        return ERROR_CODE_MAP.get(ErrorManager.getRespCode(projectCode, moduleCode, code));
    }

    public static String getRespCode(ErrorCode errorCode) {
        ProjectModule pm = errorCode.getProjectModule();
        return ErrorManager.getRespCode(pm.getProjectCode(), pm.getModuleCode(), errorCode.getCode());
    }

    public static String getRespCode(String projectCode, String moduleCode, String code) {
        return Stream.of(projectCode, moduleCode, code).filter(Objects::nonNull).map(String::trim).filter(e -> !e.isEmpty()).collect(Collectors.joining("."));
    }

    public static List<ErrorCode> getAllErrorCodes() {
        return new ArrayList<ErrorCode>(ERROR_CODE_MAP.values());
    }

    static {
        EnumSet.allOf(SystemProjectModules.class).forEach(ErrorManager::register);
        EnumSet.allOf(SystemErrorCodes.class).forEach(ErrorManager::register);
    }
}

