/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.api.model.common.response.ExtendedResponseStatus;
import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.common.tools.http.ErrorMsgBuilder;
import com.valor.vod.common.web.constant.ErrorCode;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.model.BaseResponse;
import com.valor.vod.common.web.tools.BizResponseException;
import com.valor.vod.common.web.tools.BusinessException;
import com.valor.vod.common.web.tools.ErrorManager;
import com.valor.vod.common.web.tools.VodException;
import com.valor.vod.common.web.tools.VodIllegalArgumentException;
import com.valor.vod.common.web.tools.VodIllegalStateException;
import com.valor.vod.common.web.util.TraceContext;
import common.base.tools.exception.ApiException;
import common.config.tools.config.ConfigTools3;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ConditionalOnMissingBean(annotation={ExceptionHandler.class})
@ControllerAdvice
public class VodExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(VodExceptionHandler.class);
    private static final int VOD_ERROR_STATUS = 555;

    @ExceptionHandler(value={Throwable.class})
    private ResponseEntity<ResponseStatus> handThrowable(WebRequest request, Throwable e) {
        log.error("An internal exception occurred. req:{}.", (Object)request, (Object)e);
        ResponseStatus errorResponse = this.buildResponseStatus(VodException.builder().language(this.getLanguage(request)).retCode(1).errCode(1).message("Internal Server Error.").build());
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    private ResponseEntity<ResponseStatus> handIllegalArgumentException(WebRequest request, IllegalArgumentException e) {
        log.warn("[Bad Request]", (Throwable)e);
        ResponseStatus errorResponse = this.buildResponseStatus(VodException.builder().language(this.getLanguage(request)).retCode(3).errCode(250).message(e.getMessage()).build());
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={VodIllegalArgumentException.class, VodIllegalStateException.class})
    private ResponseEntity<ResponseStatus> handVodIllegalException(WebRequest request, VodException e) {
        log.warn("[Bad Request]", (Throwable)e);
        return ResponseEntity.status((int)555).body((Object)this.buildResponseStatus(e));
    }

    @ExceptionHandler(value={VodException.class})
    private ResponseEntity<ResponseStatus> handVodException(WebRequest request, VodException e) {
        return ResponseEntity.status((int)555).body((Object)this.buildResponseStatus(e));
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    private ResponseEntity<ResponseStatus> handVodException(WebRequest request, UndeclaredThrowableException e) {
        Throwable undeclaredThrowable = e.getUndeclaredThrowable();
        if (undeclaredThrowable instanceof ApiException) {
            return this.handApiException(request, (ApiException)undeclaredThrowable);
        }
        if (undeclaredThrowable instanceof BusinessException) {
            return this.handBusinessException(request, (BusinessException)undeclaredThrowable);
        }
        if (undeclaredThrowable instanceof VodException) {
            return this.handVodException(request, (VodException)undeclaredThrowable);
        }
        return this.handThrowable(request, undeclaredThrowable);
    }

    @ExceptionHandler(value={ApiException.class})
    private ResponseEntity<ResponseStatus> handApiException(WebRequest request, ApiException e) {
        log.warn("A api exception occurred.", (Throwable)e);
        ResponseStatus errorResponse = this.buildResponseStatus(VodException.builder().language(this.getLanguage(request)).retCode(e.getRetCode()).errCode(e.getErrCode()).message("Internal Server Error.").build());
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={BusinessException.class})
    private ResponseEntity<ResponseStatus> handBusinessException(WebRequest request, BusinessException e) {
        log.warn("A business exception occurred.", (Throwable)e);
        ResponseStatus errorResponse = this.buildResponseStatus(VodException.builder().language(this.getLanguage(request)).retCode(e.getRetCode()).errCode(e.getErrCode()).message("Internal Server Error.").build());
        return ResponseEntity.status((int)555).body((Object)errorResponse);
    }

    @ExceptionHandler(value={BizResponseException.class})
    public ResponseEntity<BaseResponse<Object>> handleBizResponseException(WebRequest request, BizResponseException ex) {
        if (ex.isLog()) {
            log.warn("A business exception occurred.", (Throwable)ex);
        }
        BaseResponse resp = new BaseResponse();
        ErrorCode errorCode = ex.getErrorCode();
        String code = ErrorManager.getRespCode(errorCode);
        String language = this.getLanguage(request);
        resp.setCode(code);
        resp.setMsg(ConfigTools3.getString((String)(language + "." + code), (String)ex.getMessage()));
        this.setAndRemoveTraceId(resp);
        return ResponseEntity.status((int)errorCode.getHttpCode()).body(resp);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<BaseResponse<Object>> handleMethodArgumentException(MethodArgumentNotValidException ex) {
        BaseResponse resp = new BaseResponse();
        resp.setCode(ErrorManager.getRespCode(SystemErrorCodes.PARAM_INVALID));
        List errors = ex.getBindingResult().getAllErrors();
        if (errors.size() > 0) {
            ObjectError error = (ObjectError)errors.get(0);
            if (StringUtils.hasText((String)error.getDefaultMessage())) {
                resp.setMsg(error.getDefaultMessage());
            } else {
                StringBuilder sb = new StringBuilder(SystemErrorCodes.PARAM_INVALID.getDesc()).append(" in object '").append(error.getObjectName()).append("'");
                if (error instanceof FieldError) {
                    FieldError fieldError = (FieldError)error;
                    sb.append(" on field '").append(fieldError.getField()).append("'");
                }
                resp.setMsg(sb.toString());
            }
        } else {
            resp.setMsg(SystemErrorCodes.PARAM_INVALID.getDesc());
        }
        this.setAndRemoveTraceId(resp);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(resp);
    }

    private void setAndRemoveTraceId(ResponseStatus errorResponse) {
        errorResponse.setTraceId(TraceContext.getTraceId());
        TraceContext.removeTraceId();
    }

    private void setAndRemoveTraceId(BaseResponse<?> errorResponse) {
        errorResponse.setTraceId(TraceContext.getTraceId());
        TraceContext.removeTraceId();
    }

    private String getLanguage(WebRequest request) {
        String language = request.getHeader("Accept-Language");
        if (!StringUtils.hasText((String)language)) {
            language = Locale.ENGLISH.getLanguage();
        }
        return language;
    }

    private ResponseStatus buildResponseStatus(VodException e) {
        ExtendedResponseStatus errorResponse = new ExtendedResponseStatus();
        String errorMessage = ErrorMsgBuilder.buildErrMsgNotAppendCode((String)e.getLanguage(), (String)e.getDeviceId(), (int)e.getRetCode(), (int)e.getErrCode(), (String)e.getMessage());
        errorResponse.setStatus(e.getRetCode(), e.getErrCode(), errorMessage);
        errorResponse.setErrMessage(errorMessage);
        this.setAndRemoveTraceId((ResponseStatus)errorResponse);
        SystemErrorCodes errorCode = SystemErrorCodes.getByRetCode(e.getRetCode());
        errorResponse.setCode(ErrorManager.getRespCode(errorCode));
        errorResponse.setMsg(errorMessage);
        return errorResponse;
    }
}

