/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.web.tools;

import com.valor.vod.common.web.constant.ErrorCode;
import com.valor.vod.common.web.constant.SystemErrorCodes;
import com.valor.vod.common.web.constant.VodHttpAttr;
import com.valor.vod.common.web.tools.BizResponseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VodHttpContext {
    private static final ThreadLocal<VodHttpContext> LOCAL = ThreadLocal.withInitial(VodHttpContext::new);
    private final Map<VodHttpAttr, Object> attrMap = new HashMap<VodHttpAttr, Object>();

    public static VodHttpContext getContext() {
        return LOCAL.get();
    }

    public static void setContext(VodHttpContext context) {
        LOCAL.set(context);
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    public VodHttpContext set(VodHttpAttr key, Object value) {
        this.attrMap.put(key, value);
        return this;
    }

    public Object get(VodHttpAttr key) {
        return this.get(key, SystemErrorCodes.ATTR_NOT_FOUND);
    }

    public Object getOrDefault(VodHttpAttr key, Object defaultValue) {
        Object o = this.get(key, null);
        return Objects.isNull(o) ? defaultValue : o;
    }

    public Object get(VodHttpAttr key, ErrorCode nullErrorCode) {
        Object o = this.attrMap.get(key);
        if (Objects.isNull(o) && Objects.nonNull(nullErrorCode)) {
            throw new BizResponseException(nullErrorCode, nullErrorCode.getDesc() + ":[" + key.getName() + "]");
        }
        return o;
    }

    public String getString(VodHttpAttr key) {
        return this.getString(key, SystemErrorCodes.ATTR_NOT_FOUND);
    }

    public String getString(VodHttpAttr key, ErrorCode nullErrorCode) {
        Object o = this.get(key, nullErrorCode);
        if (Objects.isNull(o)) {
            return null;
        }
        return o.toString();
    }

    public Long getLong(VodHttpAttr key) {
        return this.getLong(key, SystemErrorCodes.ATTR_NOT_FOUND);
    }

    public Long getLong(VodHttpAttr key, ErrorCode nullErrorCode) {
        Object o = this.get(key, nullErrorCode);
        if (Objects.isNull(o)) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return Long.parseLong(o.toString());
    }

    public Integer getInteger(VodHttpAttr key) {
        return this.getInteger(key, SystemErrorCodes.ATTR_NOT_FOUND);
    }

    public Integer getInteger(VodHttpAttr key, ErrorCode nullErrorCode) {
        Object o = this.get(key, nullErrorCode);
        if (Objects.isNull(o)) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return Integer.parseInt(o.toString());
    }

    public VodHttpContext remove(VodHttpAttr key) {
        this.attrMap.remove(key);
        return this;
    }

    public VodHttpContext removeAll() {
        this.attrMap.clear();
        return this;
    }

    public static Map<VodHttpAttr, Object> getCopyOfContentMap() {
        return new HashMap<VodHttpAttr, Object>(VodHttpContext.getContext().attrMap);
    }

    public static void setContentMap(Map<VodHttpAttr, Object> attrMap) {
        VodHttpContext.getContext().attrMap.putAll(attrMap);
    }
}

