package com.valor.vod.common.cache;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.Base64Utils;
import common.base.tools.sys.SystemTools;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * Created by Frank.Huang on 2016/10/26.
 */
public class EHCacheRMIPeerProviderFactory extends RMICacheManagerPeerProviderFactory {
    public static final String ENV_EHCACHE_RMI_URLS = "mfc_cache_cluster_hosts";
    private static final Logger logger = LoggerFactory.getLogger(EHCacheRMIPeerProviderFactory.class);

    public EHCacheRMIPeerProviderFactory() {
    }

    @Override
    protected CacheManagerPeerProvider createManuallyConfiguredCachePeerProvider(Properties properties) {

        String rmiUrls = Base64Utils.decode(SystemTools.getenv(ENV_EHCACHE_RMI_URLS));
        if (!Strings.isNullOrEmpty(rmiUrls)) {
            properties.setProperty("rmiUrls", rmiUrls);
            logger.info("Use rmiUrls[{}]", rmiUrls);
        }

        return super.createManuallyConfiguredCachePeerProvider(properties);
    }
}
