package com.valor.vod.common.cache.redis;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

/**
 * Protobuf RedisTemplate
 *
 * @author Bruce Wu
 * @since 2022-09-28
 */
public class ProtobufRedisTemplate extends RedisTemplate<String, Object> {
    public ProtobufRedisTemplate() {
        setKeySerializer(RedisSerializer.string());
        setValueSerializer(ProtobufRedisSerializer.create());
        setHashKeySerializer(RedisSerializer.string());
        setHashValueSerializer(ProtobufRedisSerializer.create());
    }

    public ProtobufRedisTemplate(RedisConnectionFactory connectionFactory) {
        this();
        setConnectionFactory(connectionFactory);
        afterPropertiesSet();
    }
}
