package com.valor.vod.common.database.tool.CriteriaWrapper;

import com.google.common.collect.Sets;
import common.base.tools.type.CollectionUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.util.Set;

/**
 * Created by Frank.Huang on 2016/8/20.
 */
public class CriteriaTools {
    private Set<Criterion> criterions = Sets.newHashSet();
    private Set<Order> orders = Sets.newHashSet();

    public static CriteriaTools create() {
        return new CriteriaTools();
    }

    public Set<Criterion> getCriterions() {
        return criterions;
    }

    public Set<Order> getOrders() {
        return orders;
    }

    public CriteriaTools add(Criterion criterion) {
        criterions.add(criterion);
        return this;
    }

    public CriteriaTools addOrder(Order order) {
        orders.add(order);
        return this;
    }

    public void addToCriteria(Criteria criteria, boolean countOnly) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }

        if (!CollectionUtils.isNullOrEmpty(criterions)) {
            criterions.forEach(e -> {
                criteria.add(e);
            });
        }

        if (!countOnly) {
            if (!CollectionUtils.isNullOrEmpty(orders)) {
                orders.forEach(e -> {
                    criteria.addOrder(e);
                });
            }
        }
    }

}
