package com.valor.vod.common.tools.pubsub;

import org.springframework.data.redis.core.RedisTemplate;

/**
 * @author Tom Tang
 * @date 2022/9/3
 */
public abstract class RedisPubSubTool {

    private RedisTemplate<String, ?> redisTemplate;

    protected void setRedisTemplate(RedisTemplate<String, ?> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    /**
     * 获取Redis发布订阅的Channel
     *
     * @return Redis发布订阅的Channel
     */
    protected abstract String getChannel();

    public void pub(Object message) {
        this.redisTemplate.convertAndSend(getChannel(), message);
    }

    /**
     * 消息处理接口
     *
     * @param message 收到的消息
     */
    public abstract void onMessage(String message);
}
