package com.valor.vod.common.tools.sso;

import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.common.model.token.ServiceToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2017/1/21.
 */
public class ServiceTokenTools {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTokenTools.class);
    private static final String ST_AES_KEY = "mJIO8-VzwO9crd2LE34weg";

    public static String getServiceToken(String did, String serviceCode) {
        ServiceToken serviceToken = new ServiceToken();
        serviceToken.setDid(did);
        serviceToken.setServiceCode(serviceCode);

        return encodeServiceToken(serviceToken);
    }

    public static String encodeServiceToken(ServiceToken serviceToken) {
        if (serviceToken == null) {
            return "";
        }


        try {
            return AESUtils.encrypt(serviceToken.toSerializeString(), ST_AES_KEY);
        } catch (Exception e) {
            logger.error("encodeServiceToken exception:{}", e);
        }
        return "";
    }

    public static ServiceToken decodeServiceToken(String stStr) {
        try {
            String decodeStStr = AESUtils.decrypt(stStr, ST_AES_KEY);
            return ServiceToken.valueOf(decodeStStr);
        } catch (Exception e) {
            logger.error("decodeServiceToken exception:{}", e);
            return null;
        }
    }

}
