/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.cache.redis;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.Serializable;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class ProtobufRedisSerializer
implements RedisSerializer<Object> {
    private static final Schema<ObjectWrapper> schema = RuntimeSchema.getSchema(ObjectWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object o) throws SerializationException {
        byte[] bytes;
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            bytes = ProtostuffIOUtil.toByteArray((Object)new ObjectWrapper(o), schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        return bytes;
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            ObjectWrapper wrapper = new ObjectWrapper();
            ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)wrapper, schema);
            return wrapper.getObject();
        }
        catch (Exception e) {
            throw new SerializationException("Protobuf deserialize error.", (Throwable)e);
        }
    }

    public static ProtobufRedisSerializer create() {
        return new ProtobufRedisSerializer();
    }

    public static class ObjectWrapper
    implements Serializable {
        private Object object;

        public ObjectWrapper(Object object) {
            this.object = object;
        }

        public ObjectWrapper() {
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

