/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.database.tool.configruation;

import com.google.common.base.Strings;
import com.valor.vod.common.database.tool.configruation.AbstractDBCfg;
import common.config.tools.config.ConfigTools3;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBCfgWithDBCP2
extends AbstractDBCfg {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBCfgWithDBCP2.class);
    protected boolean poolPreparedStatements = ConfigTools3.getBoolean((String)"db.pool.poolPreparedStatements", (boolean)true);
    protected int initialSize = ConfigTools3.getInt((String)"db.pool.initialSize", (Integer)10);
    protected int maxActive = ConfigTools3.getInt((String)"db.pool.maxActive", (Integer)500);
    protected int minIdle = ConfigTools3.getInt((String)"db.pool.minIdle", (Integer)10);
    protected int maxIdle = ConfigTools3.getInt((String)"db.pool.maxIdle", (Integer)20);
    protected long maxWait = ConfigTools3.getInt((String)"db.pool.maxWait", (Integer)20).intValue();
    protected long minEvictableIdleTimeMillis = ConfigTools3.getInt((String)"db.pool.minEvictableIdleTimeMillis", (Integer)60000).intValue();
    protected long timeBetweenEvictionRunsMillis = ConfigTools3.getInt((String)"db.pool.timeBetweenEvictionRunsMillis", (Integer)60000).intValue();
    protected int numTestsPerEvictionRun = ConfigTools3.getInt((String)"db.pool.numTestsPerEvictionRun", (Integer)50);
    protected boolean testOnBorrow = ConfigTools3.getBoolean((String)"db.pool.testOnBorrow", (boolean)true);
    protected boolean testWhileIdle = ConfigTools3.getBoolean((String)"db.pool.testWhileIdle", (boolean)true);
    protected boolean testOnReturn = ConfigTools3.getBoolean((String)"db.pool.testOnReturn", (boolean)true);
    protected boolean logAbandoned = ConfigTools3.getBoolean((String)"db.pool.logAbandoned", (boolean)true);
    protected boolean removeAbandonedOnBorrow = ConfigTools3.getBoolean((String)"db.pool.removeAbandonedOnBorrow", (boolean)true);
    protected boolean removeAbandonedOnMaintenance = ConfigTools3.getBoolean((String)"db.pool.removeAbandonedOnBorrow", (boolean)true);
    protected int removeAbandonedTimeout = ConfigTools3.getInt((String)"db.pool.removeAbandonedTimeout", (Integer)120);

    @Override
    public DataSource getDataSource(String dbURL, String username, String password) {
        if (Strings.isNullOrEmpty((String)dbURL)) {
            throw new IllegalArgumentException("DB Url is empty");
        }
        if (Strings.isNullOrEmpty((String)username)) {
            throw new IllegalArgumentException("DB user is empty");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("DB password is empty");
        }
        BasicDataSource datasource = new BasicDataSource();
        datasource.setUrl(dbURL);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setValidationQuery(this.validationQuery);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements);
        datasource.setInitialSize(this.initialSize);
        datasource.setMaxTotal(this.maxActive);
        datasource.setMinIdle(this.minIdle);
        datasource.setMaxIdle(this.maxIdle);
        datasource.setMaxWaitMillis(this.maxWait);
        datasource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        datasource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        datasource.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        datasource.setLogAbandoned(this.logAbandoned);
        datasource.setRemoveAbandonedOnBorrow(this.removeAbandonedOnBorrow);
        datasource.setRemoveAbandonedOnMaintenance(this.removeAbandonedOnMaintenance);
        datasource.setRemoveAbandonedTimeout(this.removeAbandonedTimeout);
        datasource.setTestOnBorrow(this.testOnBorrow);
        datasource.setTestWhileIdle(this.testWhileIdle);
        datasource.setTestOnReturn(this.testOnReturn);
        datasource.setDefaultTransactionIsolation(2);
        return datasource;
    }
}

