/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.database.tool.configruation;

import com.valor.vod.common.database.tool.configruation.AuditInterceptor;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDBConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDBConfiguration.class);
    @Value(value="${vms.database.driver:com.mysql.jdbc.Driver}")
    protected String driverClassName;
    @Value(value="${vms.database.dialect:org.hibernate.dialect.MySQL5Dialect}")
    protected String dialect;
    @Value(value="${vms.database.poolPreparedStatements:true}")
    protected boolean poolPreparedStatements;
    @Value(value="${vms.database.validationQuery:SELECT 1}")
    protected String validationQuery;
    @Value(value="${vms.database.connections.maxIdle:10}")
    protected int maxIdle;
    @Value(value="${vms.database.connections.maxWait:500}")
    protected long maxWait;
    @Value(value="${vms.database.connections.minEvictableIdleTimeMillis:1800000}")
    protected long minEvictableIdleTimeMillis;
    @Value(value="${vms.database.connections.timeBetweenEvictionRunsMillis:1800000}")
    protected long timeBetweenEvictionRunsMillis;
    @Value(value="${vms.database.connections.numTestsPerEvictionRun:3}")
    protected int numTestsPerEvictionRun;
    @Value(value="${vms.database.connections.testOnBorrow:true}")
    protected boolean testOnBorrow;
    @Value(value="${vms.database.connections.testWhileIdle:true}")
    protected boolean testWhileIdle;
    @Value(value="${vms.database.connections.testOnReturn:true}")
    protected boolean testOnReturn;
    @Value(value="${vms.database.useL2Cache:false}")
    protected boolean useL2Cache;
    @Value(value="${vms.database.useQueryCache:false}")
    protected boolean useQueryCache;
    @Value(value="${vms.database.l2CacheFactory:org.hibernate.cache.ehcache.EhCacheRegionFactory}")
    protected String l2CacheFactory;
    @Value(value="${vms.database.showSql:false}")
    protected boolean showSql;
    @Value(value="${vms.database.statistics:false}")
    protected boolean generateStatistics;
    @Value(value="${vms.database.auto:update}")
    protected String hbm2ddlAuto;
    @Value(value="${vms.database.connections.initialSize:5}")
    private int initialSize;
    @Value(value="${vms.database.connections.maxActive:500}")
    private int maxActive;
    @Value(value="${vms.database.connections.minIdle:2}")
    private int minIdle;

    public DataSource getDataSource(String dburl, String username, String password) {
        BasicDataSource datasource = new BasicDataSource();
        datasource.setUrl(dburl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setValidationQuery(this.validationQuery);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements);
        datasource.setInitialSize(this.initialSize);
        datasource.setMaxTotal(this.maxActive);
        datasource.setMinIdle(this.minIdle);
        datasource.setMaxIdle(this.maxIdle);
        datasource.setMaxWaitMillis(this.maxWait);
        datasource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        datasource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        datasource.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        datasource.setLogAbandoned(true);
        datasource.setRemoveAbandonedOnBorrow(true);
        datasource.setRemoveAbandonedOnMaintenance(true);
        datasource.setRemoveAbandonedTimeout(180);
        datasource.setTestOnBorrow(this.testOnBorrow);
        datasource.setTestWhileIdle(this.testWhileIdle);
        datasource.setTestOnReturn(this.testOnReturn);
        datasource.setDefaultTransactionIsolation(2);
        datasource.setValidationQuery("select 1");
        logger.info("DataSource:{}", (Object)datasource.toString());
        return datasource;
    }

    public Properties getDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.show_sql", (Object)this.showSql);
        props.put("hibernate.format_sql", (Object)false);
        props.put("hibernate.generate_statistics", (Object)this.generateStatistics);
        props.put("hibernate.hbm2ddl.auto", "none");
        props.put("hibernate.connection.isolation", (Object)2);
        props.put("hibernate.use_sql_comments", (Object)true);
        props.put("hibernate.cache.use_second_level_cache", (Object)false);
        props.put("hibernate.cache.use_query_cache", (Object)false);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", (Object)true);
        props.put("hibernate.autoReconnect", (Object)true);
        return props;
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource, String ... scanPackages) {
        Properties props = this.getDBProperties();
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setEntityInterceptor((Interceptor)new AuditInterceptor());
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setPackagesToScan(scanPackages);
        sessionFactoryBean.setHibernateProperties(this.getDBProperties());
        return sessionFactoryBean;
    }

    public PlatformTransactionManager getTransactionManager(SessionFactory sessionFactory, int txTimeout) throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(sessionFactory);
        transactionManager.setDefaultTimeout(txTimeout);
        return transactionManager;
    }
}

