/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.reg;

import com.google.common.base.Strings;
import com.valor.vod.common.cache.redis.RedisCache;
import com.valor.vod.common.reg.RegisterServiceEntity;
import common.base.tools.sys.SystemTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegister {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegister.class);
    private RedisCache redisCache;
    private RegisterServiceEntity localService = null;
    private ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(2);
    private long refreshSeconds = 300L;
    private long timeoutSeconds = 720L;

    public ServiceRegister(RedisCache redisCache) {
        this.redisCache = redisCache;
        this.refreshExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceRegister.this.refresh();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, this.refreshSeconds, TimeUnit.SECONDS);
    }

    private String getRedisKey(String serviceName) {
        return "services-" + serviceName;
    }

    private void refresh() {
        if (this.localService == null) {
            logger.info("refresh(),no local service to refresh");
            return;
        }
        logger.info("refresh(),serviceName:{}", (Object)this.localService.getServiceName());
        String redisKey = this.getRedisKey(this.localService.getServiceName());
        ArrayList<RegisterServiceEntity> services = (ArrayList<RegisterServiceEntity>)this.redisCache.getWithException(redisKey);
        if (services == null) {
            services = new ArrayList<RegisterServiceEntity>();
        }
        if (services.size() == 0) {
            logger.info("refresh(),no service is found.serviceName:{}", (Object)this.localService.getServiceName());
        } else {
            logger.info("refresh(),{} service is found.serviceName:{},ip:{}", new Object[]{services.size(), this.localService.getServiceName(), this.printIp(services)});
        }
        ArrayList<RegisterServiceEntity> newServices = new ArrayList<RegisterServiceEntity>();
        boolean containLocal = false;
        for (int i = 0; i < services.size(); ++i) {
            RegisterServiceEntity ser = (RegisterServiceEntity)services.get(i);
            if (ser.getIp().equals(this.localService.getIp())) {
                ser.setCreateTime(System.currentTimeMillis());
                newServices.add(ser);
                containLocal = true;
                continue;
            }
            long lastTime = ser.getCreateTime();
            if (System.currentTimeMillis() - lastTime < this.timeoutSeconds * 1000L) {
                newServices.add(ser);
                continue;
            }
            logger.info("refresh(),ip {} is timeout,remove it.lastTime:{}", (Object)ser.getIp(), (Object)ser.getCreateTime());
        }
        if (!containLocal) {
            RegisterServiceEntity cloneSer = new RegisterServiceEntity();
            cloneSer.setIp(this.localService.getIp());
            cloneSer.setServiceName(this.localService.getServiceName());
            cloneSer.setCreateTime(System.currentTimeMillis());
            newServices.add(cloneSer);
        }
        logger.info("refresh(),{} service is refreshed.serviceName:{},ip:{}", new Object[]{newServices.size(), this.localService.getServiceName(), this.printIp(newServices)});
        this.redisCache.set(redisKey, newServices);
    }

    private String printIp(List<RegisterServiceEntity> entities) {
        StringBuilder ipSb = new StringBuilder();
        for (int i = 0; i < entities.size(); ++i) {
            if (i != 0) {
                ipSb.append(",");
            }
            ipSb.append(entities.get(i).getIp());
        }
        return ipSb.toString();
    }

    public void register(String serviceName, String ethernet, long refreshSeconds, long timeoutSeconds) {
        logger.info("register(),serviceName:{},ethernet:{}", (Object)serviceName, (Object)ethernet);
        this.refreshSeconds = refreshSeconds;
        this.timeoutSeconds = timeoutSeconds;
        String ipAddr = SystemTools.getIpAddress((boolean)true, (String)ethernet);
        if (Strings.isNullOrEmpty((String)ipAddr)) {
            return;
        }
        RegisterServiceEntity ser = new RegisterServiceEntity();
        ser.setIp(ipAddr);
        ser.setServiceName(serviceName);
        ser.setCreateTime(System.currentTimeMillis());
        this.localService = ser;
        logger.info("register(),service is registered.serviceName:{},ethernet:{},ip:{}", new Object[]{serviceName, ethernet, ipAddr});
    }

    public List<RegisterServiceEntity> getServices(String serviceName) {
        logger.info("getServices(),serviceName:{}", (Object)serviceName);
        String redisKey = this.getRedisKey(serviceName);
        List services = (List)this.redisCache.get(redisKey);
        if (services == null || services.size() == 0) {
            logger.info("getServices(),no service is found.serviceName:{}", (Object)serviceName);
            return new ArrayList<RegisterServiceEntity>();
        }
        logger.info("getServices(),{} service is found.serviceName:{},ip:{}", new Object[]{services.size(), serviceName, this.printIp(services)});
        return services;
    }
}

