/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.service;

import com.valor.vod.common.service.ChangedRunner2;
import com.valor.vod.common.service.IChangedProcessorFactory;
import com.valor.vod.common.service.IChangedScanner;
import com.valor.vod.common.tools.sys.ThreadRunTool;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedScanRunner2 {
    private static final Logger logger = LoggerFactory.getLogger(ChangedScanRunner2.class);
    private IChangedScanner scanner;
    private IChangedProcessorFactory processorFactory;
    private String scannerName = "";

    public ChangedScanRunner2(String scannerName, IChangedScanner scanner, IChangedProcessorFactory processorFactory) {
        this.scanner = scanner;
        this.processorFactory = processorFactory;
        this.scannerName = scannerName;
    }

    public void run(int maxResult, int maxThreads, int waitMS) {
        this.run(maxResult, maxThreads, waitMS, true);
    }

    public void run(int maxResult, int maxThreads, int waitMS, boolean printIfNoData) {
        BlockingQueue queue = this.scanner.getChanged(maxResult);
        if (Objects.nonNull(queue) && queue.size() > 0) {
            long beginTime = System.currentTimeMillis();
            int queueSize = queue.size();
            logger.info("batch run begin.scannerName:{},batchBeginTime:{}.try to get {} records while {} records is gotton.", new Object[]{this.scannerName, beginTime, maxResult, queueSize});
            ThreadRunTool.runThreads(maxThreads, waitMS, new ChangedRunner2(queue, this.processorFactory));
            long endTime = System.currentTimeMillis();
            logger.info("batch run end.scannerName:{},batchBeginTime:{},batchEndTime:{},cost:{}ms.{} records is dealed.", new Object[]{this.scannerName, beginTime, endTime, endTime - beginTime, queueSize});
        } else if (printIfNoData) {
            logger.info("[{}] no records need process.", (Object)this.scannerName);
        }
    }
}

