/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.cache;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SingleObjectCache<T> {
    private volatile T cached;
    private final Lock refreshLock = new ReentrantLock();
    private final long refreshInterval;
    private final TimeUnit refreshIntervalUnit;
    protected long lastRefreshTimestamp = 0L;

    public SingleObjectCache(long refreshInterval, TimeUnit refreshIntervalUnit) {
        this.refreshInterval = refreshInterval;
        this.refreshIntervalUnit = refreshIntervalUnit;
    }

    public T getOrRefresh() {
        if (this.needsRefresh() && this.refreshLock.tryLock()) {
            try {
                if (this.needsRefresh()) {
                    this.cached = this.refresh();
                    assert (this.cached != null);
                    this.lastRefreshTimestamp = System.currentTimeMillis();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        assert (this.cached != null);
        return this.cached;
    }

    public final T getNoRefresh() {
        return this.cached;
    }

    protected abstract T refresh();

    protected boolean needsRefresh() {
        if (this.cached == null) {
            return true;
        }
        long millis = this.refreshIntervalUnit.toMillis(this.refreshInterval);
        if (millis == 0L) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastRefreshTimestamp > millis;
    }
}

