/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.distributed;

import com.valor.vod.common.tools.distributed.DistributedLock;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class DistributedLockByRedisImpl
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockByRedisImpl.class);
    private RedisTemplate<String, Object> redisTemplate;
    private final String lockId;
    private final Duration expiration;

    public DistributedLockByRedisImpl(RedisTemplate<String, Object> redisTemplate, String lockId, int expirationSeconds) {
        this.redisTemplate = redisTemplate;
        this.lockId = lockId;
        this.expiration = Duration.ofSeconds(expirationSeconds);
    }

    @Override
    public boolean tryLock() {
        try {
            return Boolean.TRUE.equals(this.redisTemplate.opsForValue().setIfAbsent((Object)this.lockId, (Object)0, this.expiration));
        }
        catch (Throwable e) {
            log.error("DistributedLockByRedisImpl.tryLock error. lockId[{}]", (Object)this.lockId, (Object)e);
            throw new RuntimeException("Try lock error.");
        }
    }

    @Override
    public void unlock() {
        try {
            this.redisTemplate.delete((Object)this.lockId);
        }
        catch (Throwable e) {
            log.error("DistributedLockByRedisImpl.unlock error. lockId[{}]", (Object)this.lockId, (Object)e);
            throw new RuntimeException("Unlock error.");
        }
    }
}

