/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.mrttoken;

import com.google.common.base.Splitter;
import com.valor.vod.api.common.encrypt.AESUtils;
import com.valor.vod.common.tools.mrttoken.EMRTTokenField;
import com.valor.vod.common.tools.mrttoken.MRTToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRTTokenTools {
    private static final Logger logger = LoggerFactory.getLogger(MRTTokenTools.class);

    public static String encode(MRTToken mrtToken, String aseKey) {
        try {
            String tokenStr = AESUtils.encrypt2((String)mrtToken.toString(), (String)aseKey);
            return tokenStr;
        }
        catch (Exception e) {
            logger.error("MRTTokenTools encode exception:{}", (Throwable)e);
            return "";
        }
    }

    public static MRTToken decode(String tokenStr, String aseKey) {
        try {
            String jsonStr = AESUtils.decrypt2((String)tokenStr, (String)aseKey);
            Map tokenValues = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)jsonStr);
            MRTToken mrtToken = new MRTToken();
            tokenValues.forEach((k, v) -> {
                int key = Integer.valueOf(k);
                EMRTTokenField field = EMRTTokenField.valueOf(key);
                if (field != null) {
                    mrtToken.put(field, (String)v);
                } else {
                    logger.warn("MRTTokenTools Unknown field! key={} value={}", k, v);
                }
            });
            return mrtToken;
        }
        catch (Exception e) {
            logger.error("MRTTokenTools decode exception:{}", (Throwable)e);
            return null;
        }
    }
}

