/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.pubsub;

import com.valor.vod.common.tools.pubsub.RedisPubSubTool;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

class RedisPubSubConfiguration {
    RedisPubSubConfiguration() {
    }

    @Bean
    RedisMessageListenerContainer redisMsgListenerContainer(BeanFactory beanFactory, List<RedisPubSubTool> redisPubSubTools, String redisConnectionFactoryeBeanName, String redisTemplateBeanName) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory((RedisConnectionFactory)beanFactory.getBean(redisConnectionFactoryeBeanName, RedisConnectionFactory.class));
        this.addMessageListener(container, redisPubSubTools, beanFactory, (RedisTemplate)beanFactory.getBean(redisTemplateBeanName, RedisTemplate.class));
        return container;
    }

    private void addMessageListener(RedisMessageListenerContainer container, List<RedisPubSubTool> redisPubSubTools, BeanFactory beanFactory, RedisTemplate<String, ?> redisTemplate) {
        redisPubSubTools.forEach(redisPubSubTool -> {
            redisPubSubTool.setRedisTemplate(redisTemplate);
            MessageListenerAdapter listenerAdapter = (MessageListenerAdapter)beanFactory.getBean("redisMsgListenerAdapter", new Object[]{redisPubSubTool});
            container.addMessageListener((MessageListener)listenerAdapter, (Topic)new ChannelTopic(redisPubSubTool.getChannel()));
        });
    }

    @Bean
    @Scope(value="prototype")
    MessageListenerAdapter redisMsgListenerAdapter(RedisPubSubTool eventHandler) {
        return new MessageListenerAdapter((Object)eventHandler, "onMessage");
    }
}

