/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.common.tools.type;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expression {
    private static final Logger log = LoggerFactory.getLogger(Expression.class);
    private static final Splitter.MapSplitter AND_MAP_SPLITTER = Splitter.on((String)"&").omitEmptyStrings().trimResults().withKeyValueSeparator("=");
    private static final Splitter.MapSplitter OR_MAP_SPLITTER = Splitter.on((String)"|").omitEmptyStrings().trimResults().withKeyValueSeparator("=");
    private final ExpressionType type;
    private final Map<String, String> items;

    public static Optional<Expression> create(String expressionString) {
        if (StringUtils.isBlank((CharSequence)expressionString)) {
            return Optional.empty();
        }
        ExpressionType expressionType = Expression.getExpressionType(expressionString);
        if (expressionType == null) {
            return Optional.empty();
        }
        return Optional.of(new Expression(expressionType, expressionType.mapSplitter.split((CharSequence)expressionString)));
    }

    private static ExpressionType getExpressionType(String expressionString) {
        boolean isAndExpression = expressionString.contains("&");
        boolean isOrExpression = expressionString.contains("|");
        if (isAndExpression && isOrExpression) {
            log.error("Not support this expression. expression[{}].", (Object)expressionString);
            return null;
        }
        return isAndExpression ? ExpressionType.AND : ExpressionType.OR;
    }

    public boolean calcExpression(Predicate<? super Map.Entry<String, String>> itemPredicate) {
        return this.type.calcExpressionStream(this.items.entrySet().stream(), itemPredicate);
    }

    public static Map<String, String> parseAndExpression(String expression) {
        return StringUtils.isBlank((CharSequence)expression) ? Collections.emptyMap() : Collections.unmodifiableMap(AND_MAP_SPLITTER.split((CharSequence)expression));
    }

    public static Map<String, String> parseOrExpression(String expression) {
        return StringUtils.isBlank((CharSequence)expression) ? Collections.emptyMap() : Collections.unmodifiableMap(OR_MAP_SPLITTER.split((CharSequence)expression));
    }

    private Expression(ExpressionType type, Map<String, String> items) {
        this.type = type;
        this.items = items;
    }

    static /* synthetic */ Splitter.MapSplitter access$000() {
        return AND_MAP_SPLITTER;
    }

    static /* synthetic */ Splitter.MapSplitter access$100() {
        return OR_MAP_SPLITTER;
    }

    private static enum ExpressionType {
        AND(Expression.access$000(), Stream::allMatch),
        OR(Expression.access$100(), Stream::anyMatch);

        private final Splitter.MapSplitter mapSplitter;
        private final BiPredicate<? super Stream<Map.Entry<String, String>>, Predicate<? super Map.Entry<String, String>>> streamPredicate;

        boolean calcExpressionStream(Stream<Map.Entry<String, String>> itemStream, Predicate<? super Map.Entry<String, String>> itemPredicate) {
            return this.streamPredicate.test(itemStream, itemPredicate);
        }

        private ExpressionType(Splitter.MapSplitter mapSplitter, BiPredicate<? super Stream<Map.Entry<String, String>>, Predicate<? super Map.Entry<String, String>>> streamPredicate) {
            this.mapSplitter = mapSplitter;
            this.streamPredicate = streamPredicate;
        }
    }
}

