package com.valor.vod.common.cache;

import com.google.common.base.Strings;
import com.valor.vod.api.common.encrypt.Base64Utils;
import common.base.tools.sys.SystemTools;
import common.config.tools.config.ConfigTools3;

import static com.valor.vod.common.cache.EHCacheRMIPeerListenerFactory.ENV_EHCACHE_LOCAL;

/**
 * Created by Frank.Huang on 2016/10/28.
 */
public class EHCacheHostTools {
    public static final String ENV_EHCACHE_LOCAL_HOST = "mfc_cache_local_eth";
    public static final String ENV_EHCACHE_HOST_LIST = "mfc_cache_cluster_hosts";

    public static String getHosts() {
        return Base64Utils.decode(ConfigTools3.getString(ENV_EHCACHE_HOST_LIST));
    }

    public static String getLocalHost() {
        String networkInterfaceName = Base64Utils.decode(ConfigTools3.getString(ENV_EHCACHE_LOCAL));
        if (Strings.isNullOrEmpty(networkInterfaceName)) {
            return null;
        }
        String ipAddr = SystemTools.getIpAddress(true, networkInterfaceName);
        if (!Strings.isNullOrEmpty(ipAddr)) {
            return ipAddr;
        }

        return "";
    }

}
