package com.valor.vod.common.cache;

import com.google.common.base.Strings;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * Created by Frank.Huang on 2016/10/28.
 */
public class EHCacheJGroupsPeerProviderFactory extends JGroupsCacheManagerPeerProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(EHCacheJGroupsPeerProviderFactory.class);
    private static final String CONNECT = "connect";

    private static final String TAG_BIND_ADDR = "${bind_addr}";
    private static final String TAG_INITIAL_HOSTS = "${initial_hosts}";

    public EHCacheJGroupsPeerProviderFactory() {
    }


    @Override
    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String connect = getProperty(CONNECT, properties);
        if (!Strings.isNullOrEmpty(connect)) {
            String bindAddr = EHCacheHostTools.getLocalHost();
            if (!Strings.isNullOrEmpty(bindAddr)) {
                connect = connect.replace(TAG_BIND_ADDR, bindAddr);
            }

            String initHosts = EHCacheHostTools.getHosts();
            if (!Strings.isNullOrEmpty(initHosts)) {
                connect = connect.replace(TAG_INITIAL_HOSTS, initHosts);
            }

            properties.setProperty(CONNECT, connect);
            logger.info("EHCache JGroups connect:[{}]", connect);
        }

        return super.createCachePeerProvider(cacheManager, properties);
    }


    private String getProperty(final String name, Properties properties) {
        String property = PropertyUtil.extractAndLogProperty(name, properties);
        if (property != null) {
            property = property.trim();
            property = property.replaceAll(" ", "");
            if (property.equals("")) {
                property = null;
            }
        }
        return property;
    }
}
