package com.valor.vod.common.database.tool.access.constants;

/**
 * Created by Frank.Huang on 2016/7/9.
 */
public enum EOperator {
    UNKNOWN("#"),
    EQ("="),
    NE("!="),
    GT(">"),
    GE(">="),
    LT("<"),
    LE("<="),
    IN("in"),
    NOT_IN("not_in"),

    ;

    private String value;


    EOperator(String value) {
        this.value = value;
    }

    public static EOperator fromString(String value) {
        if (EQ.value.compareTo(value) == 0) {
            return EQ;
        }

        if (NE.value.compareTo(value) == 0) {
            return NE;
        }

        if (GT.value.compareTo(value) == 0) {
            return GT;
        }

        if (GE.value.compareTo(value) == 0) {
            return GE;
        }

        if (LT.value.compareTo(value) == 0) {
            return LT;
        }

        if (LE.value.compareTo(value) == 0) {
            return LE;
        }

        if (IN.value.compareTo(value) == 0) {
            return IN;
        }

        if (NOT_IN.value.compareTo(value) == 0) {
            return NOT_IN;
        }

        return UNKNOWN;
        //throw new IllegalArgumentException("Invalid operator:"+value);
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
