package com.valor.vod.common.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.BlockingQueue;

/**
 * Created by Frank.Huang on 2016/5/5.
 */
public class ChangedRunner2 implements IChangedRunner {

    private static final Logger logger = LoggerFactory.getLogger(ChangedRunner2.class);

    private BlockingQueue queue;
    private IChangedProcessorFactory changedProcessorFactory;

    public ChangedRunner2(BlockingQueue queue, IChangedProcessorFactory processorFactory) {
        this.queue = queue;
        this.changedProcessorFactory = processorFactory;
        if (this.changedProcessorFactory == null) {
            throw new IllegalArgumentException("Processor is null.");
        }
    }

    @Override
    public void run() {
        Object element = queue.poll();
        while (element != null) {
            IChangedProcessor changedProcessor = changedProcessorFactory.getProcessor();
            if (changedProcessor.isReady(element)) {
                try {
                    changedProcessor.onStart(element);
                    changedProcessor.onChanged(element);
                } catch (Exception e) {
                    changedProcessor.onError(element, e);
                } finally {
                    changedProcessor.onEnd(element);
                }
            }

            element = queue.poll();
        }
    }
}
