package com.valor.vod.common.tools.pubsub;

import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * 开启Redis的发布订阅功能， 与@Configuration类一起使用
 * <p>
 * 默认使用name为"vodRedisConnectionFactory"的RedisConnectionFactory和name为”redisTemplate“的RedisTemplate，
 * 可通过redisConnectionFactoryBeanName和redisTemplateBeanName方法修改。
 * </p>
 *
 * @author Tom Tang
 * @date 2022/9/4
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import({RedisPubSubRegistrar.class, RedisPubSubConfiguration.class})
public @interface EnableRedisPubSub {

    /**
     * 指定RedisConnectionFactory，默认"vodRedisConnectionFactory"
     *
     * @return 指定的RedisConnectionFactory bean name
     */
    String redisConnectionFactoryBeanName() default "vodRedisConnectionFactory";

    /**
     * 指定RedisTemplate，默认"redisTemplate"
     *
     * @return 指定的RedisTemplate bean name
     */
    String redisTemplateBeanName() default "redisTemplate";
}
