package com.valor.vod.common.tools.pubsub;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

import java.util.List;

/**
 * @author Tom Tang
 * @date 2022/8/31
 */
class RedisPubSubConfiguration {

    @Bean
    RedisMessageListenerContainer redisMsgListenerContainer(BeanFactory beanFactory,
                                                            List<RedisPubSubTool> redisPubSubTools,
                                                            String redisConnectionFactoryeBeanName,
                                                            String redisTemplateBeanName) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(beanFactory.getBean(redisConnectionFactoryeBeanName, RedisConnectionFactory.class));

        addMessageListener(container, redisPubSubTools, beanFactory,
            beanFactory.getBean(redisTemplateBeanName, RedisTemplate.class));
        return container;
    }

    private void addMessageListener(RedisMessageListenerContainer container, List<RedisPubSubTool> redisPubSubTools,
                                    BeanFactory beanFactory, RedisTemplate<String, ?> redisTemplate) {
        redisPubSubTools.forEach(redisPubSubTool -> {
            redisPubSubTool.setRedisTemplate(redisTemplate);
            MessageListenerAdapter listenerAdapter = (MessageListenerAdapter) beanFactory.getBean(
                "redisMsgListenerAdapter", redisPubSubTool);
            container.addMessageListener(listenerAdapter, new ChannelTopic(redisPubSubTool.getChannel()));
        });
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    MessageListenerAdapter redisMsgListenerAdapter(RedisPubSubTool eventHandler) {
        return new MessageListenerAdapter(eventHandler, "onMessage");
    }
}
