package com.valor.vod.common.tools.pubsub;

import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author Tom Tang
 * @date 2022/9/4
 */
class RedisPubSubRegistrar implements ImportBeanDefinitionRegistrar {

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap(
            importingClassMetadata.getAnnotationAttributes(EnableRedisPubSub.class.getName(), false));
        if (annotationAttributes == null) {
            return;
        }

        ConstructorArgumentValues beanConstructorArgumentValues =
            registry.getBeanDefinition("redisMsgListenerContainer").getConstructorArgumentValues();
        beanConstructorArgumentValues.addGenericArgumentValue(annotationAttributes.getString("redisConnectionFactoryBeanName"));
        beanConstructorArgumentValues.addGenericArgumentValue(annotationAttributes.getString("redisTemplateBeanName"));
    }

}
